proc(x) = readlist(filename)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     writelist readmatrix
; -----------------------------------------------------------------------
; Macro        readlist
; -----------------------------------------------------------------------
; Description  Reads a composed object as ASCII data from a set of files.
;              All elements of the composed object have to be numerical
;              matrices or textvectors !
; -----------------------------------------------------------------------
; Usage        obj =  readlist (filename)
; Input
;   Parameter  filename
;   Definition string
; Output
;   Parameter  obj
;   Definition composed object
; -----------------------------------------------------------------------
; Example      ; loads the library graphic
;              library ("graphic")
;              writelist (grc, "mygrc")
;              mygrc = readlist ("mygrc")
;              mygrc
; -----------------------------------------------------------------------
; Result       grc is a composed object that is created by the call of
;              graphic library. writelist creates a set of files 
;              beginning with "mygrc" which contains the elements
;              of the list.
;              "readlist" reads the set of files into mygrc. The printout
;              shows that grc and mygrc have the same structure and
;              contents.
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971030, 971107
; -----------------------------------------------------------------------
  lof   = readascii (filename, ". \t\n")
  if (lof.type[1]==10)
    lot   = matrix(rows(lof.type))
  else
    ind   = paf(1:rows(lof.type), lof.type==0)
    lot   = atof(lof.data[ind])
    ind   = paf(1:rows(lof.type), lof.type<>0)
    lof.type = lof.type[ind]
    lof.data = lof.data[ind]
  endif
  nl    = paf(1:rows(lof.type), lof.type==20)
  from  = nl[1:rows(nl)-1]+1
  to    = nl[2:rows(nl)]-1
  i     = 0
  x     = list (0)
  while (i.<rows(from))
    i = i+1
    filename = lof.data[from[i]]
    x = readcomponent (x, filename, lof.data[(from[i]+1):to[i]], lot[i+1])
  endo
  delete (x, 1)
endp
