proc (y) = reduce (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      dim paf reshape
; -----------------------------------------------------------------
;   Keywords     array manipulation
; -----------------------------------------------------------------
;   Macro        reduce
; -----------------------------------------------------------------
;   Description  Deletes all dimensions with only a single component.
; -----------------------------------------------------------------
;   Usage        y = reduce (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  y
;     Definition array, dim(y) contains no 1
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = matrix (3, 1, 2, 1)
;             reduce (x)
; -----------------------------------------------------------------
;   Result
;             Contents of y
;	      [1,]     1     1 
;	      [2,]     1     1 
;	      [3,]     1     1 
; -----------------------------------------------------------------
;   Author    TTK, 960207
; -----------------------------------------------------------------

  d = dim (x)
  y = reshape (x, paf (d, d != 1))
endp
