proc(data,datahx,y,Vin)=regressionselection(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istalinreg istastatistic regressiosave 
;              regressionstatistic linrefbs linregfs2 linregstep
; -----------------------------------------------------------------------
; Macro        regressionselection
; -----------------------------------------------------------------------
; Description  selection of different regression methods (enter, forward,
;              backward, stepwise) for the chosen X and Y variables.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------  
  textY=" (dependent) "
  data=datain
  datah=paf(data.x, data.rowcase&&data.randcase&&data.rowmissing)
  colh=data.colname
  do
    sel=choosevariable2(data,textY)  
  until(sum(sel).=0||(sum(sel).=1))
  if(sum(sel)>0)
    textX=" (independent) "
    sel1=choosevariableX(data,textX,sel)  
    if(sum(sel1)>0)
      datahx=paf(datah',sel1)'
      colhx=paf(colh,sel1)
      coltx=paf(data.coltype,sel1)
      x=datahx
      ;matrix for X variables
      y=paf(datah',sel)'
      colhy=paf(colh,sel)
      ;selection Y
      ;output=corrmatrix(datahx,colhx, coltx)
      ;output
      selhead="ISTA Linear regression"
      selitem="Enter"|"Stepwise"|"Forward"|"Backward"
      do
        selm=selectitem(selhead,selitem,"single")
        if(selm[1])
          Vin=1:cols(x) 
          {b,bse,bstan,bpval,MSSR}=istalinreg(x,y,colhx)
          MSSRin=MSSR
          selheade="Regression analysis Method: Enter"
          seliteme="Statistics"|"Save"
          do
            sele=selectitem(selheade,seliteme)
            if (sele[1])
              regressionstatistic(data,datahx,y,b,bse,bstan,bpval,Vin,colhx,colhy,MSSRin)
            endif  
            if (sele[2])
              yhat=0
              data=regressionsave(data,x,y,MSSRin,b,Vin,yhat)
            endif  
          until(sum(sele).=0)
        endif
        if(selm[2])
          opt=linregopt("mode",1)
          {b,bse,bstan,bpval,Vin,MSSRin}=linregstep(x,y,colhx,opt)
          selheadsw="Regression analysis Method: Stepwise"
          selitemsw="Statistics"|"Save"
          do
            selsw=selectitem(selheadsw,selitemsw)
            if (selsw[1])
              regressionstatistic(data,datahx,y,b,bse,bstan,bpval,Vin,colhx,colhy,MSSRin)
            endif  
            if (selsw[2])
              yhat=0
              data=regressionsave(data,x,y,MSSRin,b,Vin,yhat)
            endif  
          until(sum(selsw).=0)
        endif
        if(selm[3])
          opt=linregopt("mode",1)
          {b,bse,bstan,bpval,Vin,MSSRin}=linregfs2(x,y,colhx,opt)
          selheadfs2="Regression analysis Method: Forward"
          selitemfs2="Statistics"|"Save"
          do
            selfs2=selectitem(selheadfs2,selitemfs2)
            if (selfs2[1])
              regressionstatistic(data,datahx,y,b,bse,bstan,bpval,Vin,colhx,colhy,MSSRin)
            endif  
            if (selfs2[2])
              yhat=0
              data=regressionsave(data,x,y,MSSRin,b,Vin,yhat)
            endif  
          until(sum(selfs2).=0)
        endif
        if(selm[4])
          opt=linregopt("mode",1)
          {b,bse,bstan,bpval,Vin,MSSRin}=linregbs(x,y,colhx,opt)
          selheadbs="Regression analysis Method: Backward"
          selitembs="Statistics"|"Save"
          do
            selbs=selectitem(selheadbs,selitembs)
            if (selbs[1])
              regressionstatistic(data,datahx,y,b,bse,bstan,bpval,Vin,colhx,colhy,MSSRin)
            endif  
            if (selbs[2])
              yhat=0
              data=regressionsave(data,x,y,MSSRin,b,Vin,yhat)
            endif  
          until(sum(selbs).=0)
        endif
      until(sum(selm).=0)
    endif
  endif
endp 
