proc(roots)=rootsci(ord,di,tb,te,typ,ytt)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     domulti
; -----------------------------------------------------------------
;   Macro        rootsci
; -----------------------------------------------------------------
;   Description  calculates characteristic roots of VAR operator
; -----------------------------------------------------------------
;   Usage        roots=rootsci(ord,di,tb,te,typ,ytt)  
;   Input
;     Parameter   ord  
;     Definition      integer, VAR order
;     Parameter   di
;     Definition      integer, dimension of time series
;     Parameter   tb  
;     Definition      integer, beginning of sample
;     Parameter   te
;     Definition      integer, end of sample
;     Parameter   typ  
;     Definition      integer, model type
;     Parameter   ytt
;     Definition      matrix, time series
;   Output
;     Parameter   roots
;     Definition       matrix of characteristic roots
; -----------------------------------------------------------------
;   Author    TP A2, CH 980409
; ----------------------------------------------------------------- 
  b=coeffest(ord,di,tb,te,0,typ,ytt)
  b=agen(b[,2:di*ord+1],di,ord,typ)
  {values, vectors} = eiggn(b)    
  roots=values.re^2+values.im^2
  roots=(values) ./ (roots)
; " Characteristic roots of VAR operator "
endp;
