proc(no)=select0item(stitle,sitems,atitle)
; ----------------------------------------------------------------------------
; Library       glm
; ----------------------------------------------------------------------------
;  See_also     glmfit doglm
; ----------------------------------------------------------------------------
;   Macro       select0item
; ----------------------------------------------------------------------------
;   Description  select0item is an item selector for glm. It allows exactly 
;                at most one item to be selected. 
; ----------------------------------------------------------------------------
;   Usage        no=select0item(stitle,sitems,atitle)
;   Input
;     Parameter   stitle
;     Definition        menu title.
;     Parameter   sitems
;     Definition        menu items.
;     Parameter   atitle
;     Definition        optional, an alternative menu title if an error
;                       (more than 1 selection) occurred.
;   Output
;     Parameter   no
;     Definition        number of selected item. 0 for no selection.
; ----------------------------------------------------------------------------
;   Example   library("glm") 
;             stitle="make your choice  or  press OK"
;             sitems="1"|"2"|"3"
;             atitle="make ONE choice"
;             no=select0item(stitle,sitems,atitle)
;             no
; ----------------------------------------------------------------------------
;   Result    Your chosen number or 0 if you just pressed OK.
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; ----------------------------------------------------------------------------
;
    if (exist(atitle)==0)
      atitle=stitle
    endif
;
      numsel=selectitem(stitle,sitems)
      if (sum(numsel)>1)
        numsel=selectitem(atitle,sitems)
        while (sum(numsel)>1)
          numsel=selectitem(atitle,sitems)
        endo
      endif
;
    no=numsel.*(1:rows(numsel))
    if (sum(no)==0)
      no=0
    else
      no=paf(no,no.>0)
    endif
endp










