proc(r) = statstest()
; -----------------------------------------------------------------
; Library        stats
; -----------------------------------------------------------------
;  See_also      
; -----------------------------------------------------------------
;   Macro        statstest
; -----------------------------------------------------------------
;   Description  executes some tests for the macros defined
;                in stats.lib. Is invoked by vertestl().
; -----------------------------------------------------------------
;   Usage        statstest ()
;   Input
;     Parameter   
;     Definition        none     
;   Output
;     Parameter  r
;     Definition        0 if test was o.k., 1 otherwise    
; -----------------------------------------------------------------
;   Author      Marlene Mueller, 970903
; -----------------------------------------------------------------
;
; bootstrap
randomize(12345) 
     n     = 150 
     eps   = normal(n) 
     beps  = bootstrap(eps,99,"wild") 
; 
; boxcox
x=exp(normal(500)) ; log-normal data
;     boxcox(x)
;
; fivenum
fivenum (x)
;
; linreg
randomize(1964) 
     n = 500 
     x = normal(n,3) 
     beta = #(10, 2, 3) 
     u = 0.5 * normal(n)  
     y = x*beta .+ u 
     {beta,se,betastan,p} = linreg(x,y)  
randomize(1964) 
     n = 50 
     x = normal(n,3) 
     beta = #(10, 2, 3) 
     u = 0.5 * normal(n)  
     y = x*beta .+ u 
     covar = (0.5.*x[,2] .+ 0.3.*x[,3]+ 0.2*x[,1]).^2 
     y = x*beta .+ sqrt(covar).*u 
     opt="nointercept"|"display"|"omega"
     {beta,se,betastan,p} = linreg(x,y,opt,diag(covar))    
;
; linregfs
randomize(0) 
     x = normal(1000, 3) 
     y = 10*x[,3]+x[,1].*x[,2] 
     {xfs,bfs}=linregfs(x, y, 0.05) 
;
; linregres
randomize(0) 
     x = normal(100, 3) 
     y = 10*x[,3]+x[,1].*x[,2] 
     {xfs,bfs}=linregfs(x, y, 0.05) 
     {res,out}=linregres(xfs, y, xfs*bfs) 
;
; descriptive, summarize, frequency
x=read("bank2") 
     xvars="length"
     xvars="length"|"l_height"|"r_height"|"u_frame"|"l_frame"|"diagonal" 
     descriptive(x[,1],xvars[1])
     summarize(x,xvars) 
     frequency(x[,1],xvars[1])
;
; crosstable
randomize(970701) 
     x = ceil(normal(100,2)) ; rounded independent random numbers 
     crosstable(x)
;
; tableN
n=100 
     x=ceil(normal(n,2)) 
     {xr,yr}=tableN(x) 
     sum(yr)    ;   must be 100 
;
; categorize
randomize(0) 
     x=ceil(normal(50,3)-0.5) 
     {xc,xcvars}=categorize(x,"value",1|0|NaN)
;
r=0 
endp



