proc(b,s)=sur(surlist1,surlist2)
; ---------------------------------------------------------------------
; Library     metrics
; ---------------------------------------------------------------------
; See_also    seq
; ---------------------------------------------------------------------
; Macro       sur
; ---------------------------------------------------------------------
; Description Estimates a seemingly unrelated regression system by feasible generalized least squares 
; ---------------------------------------------------------------------
; Usage       (b,s)=sur(surlist1,surlist2)
; Input        
; Parameter           surlist1
; Definition          list of matrices. If there are M equations then surlist1
;			will be a list of M+1 matrices.  The first matrix is comprised of 
;			the vectors of observations of the left-hand side variables. Each of the 
;			next M matrices consists of the observations of the right-hand-side 
;			variables of one of the M equations of the system. 
; 	Parameter	surlist2
; 	Definition	list of string vectors. If there are M equations then surlist2
;			will be a list of M+1 string (column) vectors. Each vector contains 
;			the names of the variables of the corresponding matrix from surlist1. 
; Output      
; Parameter   b        
; Definition          vector, containing the generalized least squares coefficient estimates
; Parameter   s        
; Definition          vector, containing the estimated standard errors of the components of b
; ---------------------------------------------------------------------
; Notes       Greene (1996)  or any other good econometrics textbook
; ---------------------------------------------------------------------
; Example     
; library("xplore")                            
; z=read("carc.dat")                           
; price=z[,2]                                  
; weight=z[,9]                                 
; foreign=(z[,14].<>1)                         
; mpg=z[,3]                                    
; displ=z[,12]                                 
; length=z[,10]                                
; n=rows(z)                                    
; one = matrix(n,1)                            
; lhs=price~mpg~displ                          
; x1=one~foreign~weight~length                 
; x2=one~foreign~weight                        
; x3=one~foreign~weight                        
; surlist1=list(lhs,x1,x2,x3)                  
; ; setting up the string vectors for surlist2 
; yl="price"|"mpg"|"displ"                     
; zl1="one"|"foreign"|"weight"|"length"        
; zl2="one"|"foreign"|"weight"                 
; zl3="one"|"foreign"|"weight"                 
; surlist2=list(yl,zl1,zl2,zl3)                
; {b,s}=seq(surlist1,surlist2)
; ---------------------------------------------------------------------
; Result  You will find the following output in the output window 
;
; Contents of outputgls                                           
;                                                                
;                                                                
; [ 1,] "====================================================="   
; [ 2,] "   Generalized Least-squares estimates"                  
; [ 3,] "====================================================="   
; [ 4,] " EQ  dep. var.      R2 "                                 
; [ 5,] "====================================================="   
; [ 6,] " 1   price                  0.586     "                  
; [ 7,] " 2   mpg                    0.686     "                  
; [ 8,] " 3   displ                  0.822     "                  
; [ 9,] "====================================================="   
; [10,] "VARIABLE    Coef.Est.        Std.Err.          t"        
; [11,] "--------------------------------------------------"      
; [12,] "one         7635.062       3698.595          2.064"      
; [13,] "forei       3486.077        587.354          5.935"      
; [14,] "weigh          6.426          0.956          6.724"      
; [15,] "lengt       -116.055         32.896         -3.528"      
; [16,] "---------------------------------------------------------
; [17,] "one           41.471          2.005         20.683"      
; [18,] "forei         -1.425          1.007         -1.414"         
; [19,] "weigh         -0.007          0.001        -11.093"      
; [20,] "---------------------------------------------------------
; [21,] "one          -86.899         23.972         -3.625"      
; [22,] "forei        -25.257         12.043         -2.097"      
; [23,] "weigh          0.097          0.007         13.704"      
; [24,] "====================================================="   
;                                                                  
; ---------------------------------------------------------------------
; Keywords    seemingly unrealted regression SUR
; ---------------------------------------------------------------------
; Author      aw (000711)
; ---------------------------------------------------------------------

; figuring out the number of equations

L=size(surlist1)    ; number of items in the list
M=L-1               ; number of equations

; setting up data as regression system

y=surlist1{1}
yl=vec(y)
x1=surlist1{2}
xM=surlist1{L}
r1=rows(x1)*(M-1)
x=x1|zeros(r1,cols(x1))


	j=2 
	while (j<=M-1)
	r2=rows(y)*(j-1)
	r3=rows(y)*(M-j)
	x=x~(zeros(r2,cols(surlist1{j+1}))|surlist1{j+1}|zeros(r3,cols(surlist1{j+1})))
	j=j+1
	endo
x=x~(zeros(r1,cols(xM))|xM)

; ordinary least squares estimates

bols=inv(x'*x)*(x'*yl)


; residuals and their covariance matrix

e=yl-x*bols
e=reshape(e,#(rows(y),M))
cove =(rows(y)-1)/rows(y)* cov (e) 


; GLS estimator, its covariance matrix, standard errors and t-ratios

siginv = inv(kron(cove,unit(rows(y))))
bgls=inv(x'*siginv*x)*x'*siginv*yl
varb=inv(x'*siginv*x)
s=sqrt((varb.*unit(rows(bgls))*matrix(rows(bgls))))
t=bgls./s
b=bgls

; R-squared

sigy=(rows(y)-1)/rows(y)* cov(y)

R2=1-((cove.*unit(rows(cove)))*matrix(rows(cove),1))./((sigy.*unit(rows(sigy)))*matrix(rows(sigy),1))


; formatting output of GLS-estimation

fmt = "     %10.3f"
bglsstr = string (fmt, bgls)
stdbstr = string (fmt, s)
tstr = string (fmt, t)

	line1="   Generalized Least-squares estimates"
	line2="=====================================================" 
	line3=" EQ	dep. var.		R2	"
	line4="=====================================================" 
	
	eqtext=string("%2.0f	", 1:M)
	deptext=substr(surlist2{1}+"          ",1,10)
	r2text=string("%0.3f",R2)
	header=eqtext+deptext+"              "+r2text+"     "


	line5="=====================================================" 
	line6="VARIABLE    Coef.Est.        Std.Err.          t"    
 
	thinline="--------------------------------------------------"

	nicetext=substr(surlist2{2}+"     ",1,6)
	rf=1
	rs=rows(surlist2{2})
	paratext=bglsstr[rf:rs,]
	setext=stdbstr[rf:rs,]
	ttext=tstr[rf:rs,]
	rl=rs

	l=3
	while (l<=M+1)
	rf=rl+1
	rs=rows(surlist2{l})	
	rl=rl+rs
	nicetext=nicetext|thinline|substr(surlist2{l}+"     ",1,6)
	paratext=paratext|thinline|bglsstr[rf:rl,]
	setext=setext|thinline|stdbstr[rf:rl,]
	ttext=ttext|thinline|tstr[rf:rl,]
	l=l+1
	endo
	text=nicetext+paratext+setext+ttext

outputgls=line2|line1|line2|line3|line4|header|line5|line6|thinline|text|line2
outputgls

endp
library("metrics")

