proc (r) = timestest ()
; -----------------------------------------------------------------------
; Library	times
; -----------------------------------------------------------------------
; See_also
; -----------------------------------------------------------------------
; Macro		timestest
; -----------------------------------------------------------------------
; Description	executes some tests for the macros defined in times.lib
; -----------------------------------------------------------------------
; Usage		timestest ()
; Input
; Output
;   Parameter   r
;   Definition  scalar, 0 no error, 1 at least one error
; -----------------------------------------------------------------------
; Example 	library("times")
; 		timestest()
;------------------------------------------------------------------------
; Result	Content of object r
;		  [1,] 0
; -----------------------------------------------------------------------
; Author	Christian Hafner, 990621
; -----------------------------------------------------------------------
    r = 0
    randomize(0) 
    x = normal(100)  
; testing  the autocorrelation function **** 	
    a1 = acf(x)
    s1=-0.15902
    h=abs(a1[2]- s1) > 1e-2
    error (h , "acf seems to calculate wrong")
    r = r || h  	 
; testing the partial autocorrelation function ****
    a2 = pacf(x, 20)
    s2=-0.15022
    h=abs(a2[2]- s2) > 1e-2
    error (h , "pacf seems to calculate wrong")
    r = r || h  
; testing the correlation integral
    c=corrint(x,2)
    s3 = -0.67811
    h=abs(c[1,1] - s3) > 1e-2 
    error (h , "corrint seems to calculate wrong")
    r = r || h
; testing the generation of an ARMA(1,1) process
    g1 = genarma(0.7,0.3,x)
    s4 = -0.90515
    h = abs(mean(g1) - s4) > 1e-2 
    error (h , "genarma seems to calculate wrong")
    r = r || h
; testing the generation of a GARCH(1,1) process
    randomize(0)
    g2 = genarch(0.1|0.2, 0.7, 100)
    s5 = 0.84786
    h = abs(mean(g2{2}) - s5) > 1e-2
    error (h , "genarch seems to calculate wrong")
    r = r || h
; testing the CLS estimation of an ARMA(1,1) process
    randomize(0)
    g1e1 = armacls(normal(10), 1, 1)
    s6 = 0.0249
    h = abs(g1e1{1}[1] - s6) > 1e-2
    error (h, "armacls seems to calculate wrong")
    r = r || h
; testing the likelihood estimation of an ARMA(1,1) process
    randomize(0)
    g1e2 = armalik(normal(10))
    s7 = 0.087369
    h = abs(g1e2{1}[1] - s7) > 1e-2
    error (h, "armalik seems to calculate wrong")
    r = r || h
; testing the likelihood estimation of a GARCH(1,1) process
    randomize(0)
    z = archest(normal(10),1,1) 
    s8 = 1.1099
    h=abs(z{1}{1}[1] - s8) > 1e-2 
    error (h , "archest seems to calculate wrong")
    r = r || h 
; testing the difference operator
    z=tdiff(1:3)
    h = abs(sum(z)-2)>1e-2
    error (h , "tdiff seems to calculate wrong")
    r = r || h
;   testing the periodogram
    z=pgram(1:10)
    h = abs(sum(z) - 37.437) > 1e-2
    error (h , "pgram seems to calculate wrong")
;   testing the spectral density estimate
    z=spec(1:10)
    h = abs(sum(z) - 32.687) > 1e-2
    error (h , "spec seems to calculate wrong")
;   testing the parzen window
    z = parzen(0,9)
    h = abs(z - 6.75) > 1e-2
    error (h , "parzen seems to calculate wrong")
;   testing the generation of bilinear processes
    z=genbil(0.5|0.2, 0.3|-0.3, 0.8|0|0|0.3,-3:3)
    h = abs(sum(z) - 936.09) > 1e-2
    error (h , "genbil seems to calculate wrong")
;   testing the generation of expar processes
    z=genexpar(1,0.1,0.3|0.6, 2.2|-0.8,1:5)
    h = abs(sum(z) - 158.33) > 1e-2
    error (h , "genexpar seems to calculate wrong")
;   testing the generation of threshold AR processes
    z=gentar(2,1,0,0.5|-0.5,1:5)
    h = abs(sum(z) - 12.94) > 1e-2
    error (h , "gentar seems to calculate wrong")
;   
endp    
