proc(b,s,cv)=tobit(x,y)
; -----------------------------------------------------------------
; Library        metrics
; -----------------------------------------------------------------
;  See_also      glmest
; -----------------------------------------------------------------
;   Macro        tobit
; -----------------------------------------------------------------
;   Description  2-step estimation of a Tobit model     
; -----------------------------------------------------------------
;   Usage        {b,s,cv} = tobit(x,y)    
;   Input
;     Parameter   x  
;     Definition      n x d matrix , the observed explanatory variable    
;     Parameter   y 
;     Definition      n x 1 matrix , the observed response variable       
;   Output                                                                   
;     Parameter   b 
;     Definition       d x 1 vector, contains the estimated coefficients of the components of x 
;     Parameter   s 
;     Definition       scalar, contains the estimated standard deviation of the error term
;     Parameter   cv
;     Definition       (d+1)x(d+1) matrix, estimated covariance matrix for [b,s]
;     Reference	G.S. Maddala (1983): Limited-Dependent and Qualitative Variables in
;		Econometrics, Chapter 8	
; -----------------------------------------------------------------
;   Example   library("metrics")
;	n	=	500
;	k	=	2
;	x	=	matrix(n)~aseq(1, n ,0.25)
;	s	=	8
;	u	=	s*normal(n)
;	b	=	#(-9, 1)
;	ystar	=	x*b+u
;	y	=	ystar.*(ystar.>=0)
;       tstep	= 	tobit(x,y)
;	tstep.b
;	tstep.s
;	tstep.cv
;	dg	=	matrix(rows(tstep.cv),1)
;	dig	=	diag(dg)
;	stm	=	dig.*tstep.cv
;	std	=	sqrt(sum(stm,2))
;	coef	=	tstep.b|tstep.s
;	coef~(coef./std)	; t-ratios
; -----------------------------------------------------------------
;   Result    2-step estimates of b and s 
; -----------------------------------------------------------------
;   Author    akw   06/05/96  
; -----------------------------------------------------------------
	q	= (y.>0) 
	probit	= glmest("bipro",x, q) 
	id	= x*(probit.b)
	ld	= pdfn(id)./(cdfn(id)+1e-10) 
	data	= y~x~ld~id
	data	= paf(data, q)
	y  	= data[,1]
	z  	= data[,2:(cols(data)-1)]
	idp	= data[,cols(data)]
	ldp	= z[,cols(z)]
	bs 	= gls(z,y)
	b  	= bs[1:(cols(z)-1),]
	s  	= bs[cols(z),]
; ********************************************
; ****** Adjusted Covariance Matrix **********
; ********************************************
; ****** See Amemiya (1985), p.370  **********
; ********************************************
d1	=	pdfn(id)^2./((cdfn(id).*(1-cdfn(id)))+1e-10);	elements of D1
ss	=	(1-(idp.*ldp)-(ldp)^2) 		;elements of sigma
isx	=	(1-ss).*z[,1:(cols(z)-1)]	;(I-E)X
zz	=	z*inv(z'*z)			;Z'(Z'Z)^(-1)
xdx	=	inv(x'*(d1.*x))			;(X_'*D1*X_)^{-1}
cv2	=	s^2*(zz'*isx*xdx*isx'*zz)	
cv1	=	s^2*(zz'*(ss.*z)*inv(z'*z))
cv	=	cv1+cv2
endp
  
