proc()=twclt(p)
; ---------------------------------------------------------------------
; Library     tware	
; ---------------------------------------------------------------------
; See_also    twrandomsample twpvalue twnormalize twpearson tw1d twlinreg
; ---------------------------------------------------------------------
; Macro       twclt
; ---------------------------------------------------------------------
; Description teachware quantlet twclt shows a discrete four point
;							distribution and simulates repeated sampling from this			 
;							apparently non normal distribution. The variation of the 
;							observed mean values around the true mean value 
;							(standardized by scale) is shown in a plot. The user may 
;							interactively change the number of samples and thereby 
;							study the effect of the central limit theorem (CLT).
; ---------------------------------------------------------------------
; Usage       twclt({p})
; Input       
; Parameter  	p  
; Definition  vector (4 x 1) with user defined probablities
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     ; load teachware library
;            library("tware")
;            ; predefine probs for the numbers 1,2,3,4
;            p=0.25|0.25|0.25|0.25
;            ; call twclt teachware quantlet
;            twclt(p)
; ---------------------------------------------------------------------
; Result     a two window port display with the discrete four point 
;						distribution in the lower port and the distribution of the 
;						mean values in the upper port. 
; ---------------------------------------------------------------------
; Keywords    teachware
; ---------------------------------------------------------------------
; Reference   Hrdle, W., Klinke, S. and Marron, J.S. (1999) Connected
;							teaching of statistics
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      SK, WH, 990102
; ---------------------------------------------------------------------
  if (exist(p)<>1)				// check for optional input 
    p   = 0.25|0.25|0.25|0.25
  endif 
  p = p./sum(p)						// standardize to probs
  str = "P(X=1)"|"P(X=2)"|"P(X=3)"|"P(X=4)"
  p   = readvalue(str, p)
  pw  = cumsum(p./sum(p))
  d   = createdisplay(2,1)
  i = 1:4
  grbin = (i-1/3)|(i-1/3)|(i+1/3)|(i+1/3)	// generate bars
  grbin = grbin~((0*i)|p|p|(0*i))		
  n   = 4
  lt1 = (i~(n+i)~(2*n+i)~(3*n+i)~i)	
  setmaskp(grbin, 0, 0, 0)			// get rid of point structure
  setmaskl(grbin, lt1, 4, 1, 0)			// define which pts to connect
  show(d, 2, 1, grbin)
  setgopt (d, 2, 1, "title", "distribution")
  show(d, 2, 1, grbin)
// ************************************************ now the simulation part
  n   = 30
  selhead = "Change number of samples"
  selitem = "-100"|"-50"|"-10"|"+10"|"+50"|"+100"|"Quit"
  do 
    if (n>0)
      u = uniform(n,n)
      u = 1+(u<pw[1])+(u<pw[2])+(u<pw[3])
      u = mean(u, 2)
      show(d,1,1,grhist(u, (max(u)-min(u))/30))
      tit = string("Distribution of mean x with %.0f samples", n)
      setgopt(d,1,1, "title", tit)
    endif
    sel = selectitem(selhead, selitem, "single")
    if (sel[1])
      n = n-100
    endif
    if (sel[2])
      n = n-50
    endif
    if (sel[3])
      n = n-10
    endif
    if (sel[4])
      n = n+10
    endif
    if (sel[5])
      n = n+50
    endif
    if (sel[6])
      n = n+100
    endif
  until (sel[7])
endp

