proc(uselret)=twles2(usel)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     twles1 twles3 twles4 twles5 twles6 twles7 twles8
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        twles2
; -----------------------------------------------------------------------
; Description  Compares the data compression of wavelets with fourier 
;              basis.
;              You can choose between different wavelet base, different 
;              number of father wavelet coefficients, different functions 
;              and different views to the mother wavelet coefficients.
; -----------------------------------------------------------------------
; Usage        twles2(NaN)
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  if (existglobal("DisplaySize"))
    ds = getglobal("DisplaySize")
  else
    ds = 400
  endif
  setsize (2*ds, ds)
  d2  = createdisplay(2,2) 
  n = 128
  {tmp, x} = chfunc (NaN, 0, n, #(0,1,0,0))
  h = getglobal ("daubechies4")
  l = 4
  v = 2
  {a, b} = fwt (x, l, h)
  y = fft (x~(0.*matrix(rows(x))))
  bf = (log(n)./log(2).*matrix(rows(y)))~(1:rows(y))~sqrt(sum(y^2,2))
  af = 0~0
  selhead = "Wavelet lesson 2"
  selitem = "Change basis"|"Change level"|"Change function"|"Change view"|"Print"
  end = 0
  do
    if (v.=1)
      waveint1b (d2, 1, a, b, x, 0)
      waveint1b (d2, 2, af, bf, x, 0)
    endif
    if (v.=2)
      waveint3b (d2, 1, a, b, x, 0)
      waveint3b (d2, 2, af, bf, x, 0)
    endif
    if (v.=3)
      waveint2b (d2, 1, a, b, x, 0, b)
      waveint2b (d2, 2, af, bf, x, 0, bf)
    endif
    if (v.=4)
      waveint4b (d2, 1, a, b, x, 0, l, h)
      waveint3b (d2, 2, af, bf, x, 0)
    endif
    ru = rows(usel)
    if (ru.>1)
      sel  = (usel[2].=(1:5))
      if (ru.>2)
        usel = usel[1]|usel[3:ru]
      else
        usel = usel[1]
      endif
    else
      sel = selectitem (selhead, selitem)
    endif
    end = sum(sel).=0
    if (sel[1])
      {usel, h} = chbase (usel, h)
      {a, b} = fwt (x, l, h)
    endif
    if (sel[2])
      ru = rows(usel)
      if (ru.>1)
        l    = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        do
          l = readvalue ("Change level", l)
        until ((l>3) && (l<rows(x)))
      endif
      l = 2^floor(log(l)./log(2))
      {a, b} = fwt (x, l, h) 
    endif  
    if (sel[3])
      {usel, x} = chfunc (usel, x, n, 0)
      {a, b} = fwt (x, l, h)
      y = fft (x~(0.*matrix(rows(x))))
      bf = (log(n)./log(2).*matrix(rows(y)))~(1:rows(y))~sqrt(sum(y^2,2))
      af = 0~0
    endif
    if (sel[4])
      {usel, v} = chview(usel, v)
    endif
    if (sel[5])
      usel = twprint (d2, usel)
    endif
  until (end)
  uselret = usel
endp
