proc(uselret)=twles7(usel)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     twles1 twles2 twles3 twles4 twles5 twles6 twles8
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        twles7
; -----------------------------------------------------------------------
; Description  Shows how a hard threshold behaves on an image
;              and an image plus noise.
;              You can choose between different wavelet base, different 
;              number of father wavelet coefficients and different views 
;              to the mother wavelet coefficients.
; -----------------------------------------------------------------------
; Usage        twles7()
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912,  Sperlich 980709 
; -----------------------------------------------------------------------
  if (existglobal("DisplaySize"))
    ds = getglobal("DisplaySize")
  else
    ds = 400
  endif
  setsize (ds, ds)
  d7  = createdisplay(2,3) 
  z = read("pic29.dat")
  n = sqrt(rows(z))
  x = reshape(z, #(n,n))
  xf = x
  h = getglobal ("daubechies4")
  l = 1
  c = fwt2 (x, l, h, 0)
  cf = c
  dev = 0
  selhead = "Wavelet lesson 7"
  selitem = "Change basis"|"Noise level"|"Hard Threshold"|"Print"
  end = 0
  waveint5b (d7, 1, c, x)
  do
    ru = rows(usel)
    if (ru.>1)
      sel  = (usel[2].=(1:4))
      if (ru.>2)
        usel = usel[1]|usel[3:ru]
      else
        usel = usel[1]
      endif
    else
      sel = selectitem (selhead, selitem)
    endif
    end = sum(sel).=0
    if (sel[1])
      {usel, h} = chbase (usel, h)
      cf = fwt2 (xf, l, h, 0)
      waveint5b (d7, 2, cf, xf)
    endif
    if (sel[2])
      ru = rows(usel)
      if (ru.>1)
        dev = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        dev = readvalue ("Deviation:", dev)
      endif
      randomize(0)
      xf = x + 10*dev*normal(n,n)
      cf = fwt2 (xf, l, h, 0)
      waveint5b (d7, 2, cf, xf)
    endif
    if (sel[3]) 
      n2  = n/2  
      cm = cf[n2+1:n,n2+1:n]
      reshape("cm",   #(n2*n2,1))
      cm = sort(abs(cm))
      cm = cm[n2*n2/2]/0.6745*sqrt(2*log(n*n))
      ru = rows(usel)
      if (ru.>1)
        t = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        t = readvalue("Hard Threshold", cm)
      endif
      ct = c.*(abs(c).>t)
      xt = invfwt2 (ct, l, h, 0)
      waveint5b (d7, 3, cf, xt)
    endif
    if (sel[4])
      usel = twprint (d7, usel)
    endif
  until (end)
  uselret = usel
endp
