proc()=twpearson(x)
; ---------------------------------------------------------------------
; Library     tware
; ---------------------------------------------------------------------
; See_also    twrandomsample twpvalue twnormalize tw1d twlinreg twclt 
; ---------------------------------------------------------------------
; Macro       twpearson
; ---------------------------------------------------------------------
; Description teachware quantlet twpearson gives a visual demonstration 
;							of the form of the Pearson correlation coefficient.  
;							In particular, it shows why the product moment gives a 
;							measure of "dependence", and why it is essential to 
;							"normalize", i.e. to subtract means, and divide by 
;							standard deviations, to preserve that property. 
; ---------------------------------------------------------------------
; Usage       twpearson({x})
; Input       
; Parameter   x
; Definition  matrix (n x 2) with user defined data 
; ---------------------------------------------------------------------
; Notes       The parameter x is optional. If it is not given, the user
;							is asked to define the desired correlation interactively.
; ---------------------------------------------------------------------
; Example    ; load teachware library
;            library("tware")
;            ; predefine matrix 
;            x = normal(100,2) 
;            ; call twpearson teachware quantlet
;            twpearson(x)
; ---------------------------------------------------------------------
; Result    a two window port display with the scatterplot of the matrix x 
;						in the upper port and the values of the product moments 
;						in the lower (text) port.  
; ---------------------------------------------------------------------
; Keywords    teachware
; ---------------------------------------------------------------------
; Reference   Hrdle, W., Klinke, S. and Marron, J.S. (1999) Connected
;							teaching of statistics
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author    SK, WH, 990103
; ---------------------------------------------------------------------
  if (exist("x")<>1)					// check for optional input		
    p = 100|0								
    p = readvalue("Datapoints"|"Correlation", p)	// ask for correlation
    sig = #(1, p[2])~#(p[2], 1)
    {e,v} = eigsm(sig)
    x = normal(p[1],2)*(v*diag(sqrt(e))*v')
  endif
  n = rows(x)
  d = createdisplay(2,1)				// create window ports
  sf = 0|0|1|1							// default parameters
	xt = (sf[3]*(x[,1]-sf[1]))~(sf[4]*(x[,2]-sf[2]))
	do 
		mt = mean(xt)
		vt = var(xt)
    sxy  = sum(xt[,1].*xt[,2])/(n-1)			// product moment
    sxyv = (xt[,1]-mt[,1]).*(xt[,2]-mt[,2])		// mean corrected product moment
    sxyb = sum(sxyv)/(n-1)
    m    = max(abs(sxyv))
    col  = bindata(sxyv, m/3.99, 0)			// code size of points
    color = NaN.*matrix(n)
    size  = 4+(abs(col.xb+0.5)-0.5)*2			// far away point appear larger
    if (sum(col.xb<0))
      ind = paf(1:n, col.xb<0)
      color[ind] = 1  					// code 1., 3. quadrant red
    endif 
    if (sum(col.xb>=0))
      ind = paf(1:n, col.xb>=0)
      color[ind] = 4					// code 2., 4. quadrant blue
    endif 
    setmaskp(xt, color, 3, size)
		setmaskp(x, 0, 2, 4)				// color original data in black
 		rho  = sxyb/sqrt(vt[,1]*vt[,2])
    txt  = string     ("sum_i x_i y_i                             = %8.4f", sxy)
    txt  = txt|string ("sum_i (x_i-xb) (y_i-yb)                   = %8.4f", sxyb)
    txt  = txt|string ("(sum_i (x_i-xb) (y_i-yb)) / sqrt(Sxx Syy) = %8.4f", rho)
    txt  = txt|"****************************************************"
		txt  = txt|string("mean xb   = %8.4f      yb    = %8.4f", mt[,1], mt[,2])
    txt  = txt|string("xshift    = %8.4f  yshift    = %8.4f", sf[1], sf[2])
	  txt  = txt|"----------------------------------------------------"
    txt  = txt|string("sqrt(Sxx) = %8.4f  sqrt(Syy) = %8.4f", sqrt(vt[,1]), sqrt(vt[,2]))
    txt  = txt|string("xscale    = %8.4f  yscale    = %8.4f", sf[3], sf[4])
    show(d,1,1,xt,x)
    show(d,2,1,txt)
    osf = sf
    sf  = readvalue("X Shift: "|"Y Shift: "|"X Rescale: "|"Y Rescale: ", sf)
		xt = (sf[3]*(x[,1]-sf[1]))~(sf[4]*(x[,2]-sf[2]))
  until (sum(abs(osf-sf))<1.0e-3)
endp



