proc(B,u,s,g)=varunls(y,p,trend)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     varml
; -----------------------------------------------------------------
;   Macro        varunls
; -----------------------------------------------------------------
;   Description  computes the unconstrained least squares estimates of the model parameters (B), residuals (u), variance-covariance matrix of the residuals (s), and autocovariance matrix of the time series (g) of a K-dimensional VAR(p) model with/ without intercept
; -----------------------------------------------------------------
;   Usage        {B,u,s,g} = varunls(y,p,trend)     
;   Input
;     Parameter     y
;     Definition    (K x p+T) matrix of p presample, and T sample observations              
;     Parameter    p
;     Definition    (1 x 1) integer, VAR-process order, number of lags in the model, p=1,2,3,...
;     Parameter    trend
;     Definition    (1 x 1) integer, indicator whether intercept is estimated or not, if trend=1 intercept is estimated, if trend=0 no intercept is estimated
;   Output                                                           
;     Parameter   B    
;     Definition  (K x trend+K*p) matrix,  model parameters (nu~)A_1~A_2~...~A_p  
;     Parameter   u
;     Definition  (K x T) matrix, least squares estimates of residuals
;     Parameter  s
;     Definition  (K x K) matrix, least squares estimate of residual variance-covariance matrix
;     Parameter  g
;     Definition  (K*p+trend x K*p+trend) matrix, autocovariance matrix of time series 
; -----------------------------------------------------------------
;   Author Benkwitz, 980127
; -----------------------------------------------------------------
    error(!(trend==1 || trend==0),"ERROR: intercept is not specified by 0 or 1")
    error(p<0,"ERROR: VAR-order cannot be negative!")
    if (p==0)
        B=0
        s=y*y'/cols(y)
        u=y
        g=0
    else
	t=cols(y)-p
        z=y[,1:t]
        i=2
        while (i<=p)
            z=y[,i:t+i-1]|z
            i=i+1
        endo
        if (trend)
            z=ones(1,t)|z
        endif
        y=y[,p+1:t+p]
        B=y*z'*inv(z*z')
        u=y-B*z
        s=u*u'/(t-rows(y)*p-trend)
        g=z*z'/t
    endif
endp
