; -----------------------------------------------------------------
;   Macro       vertestl
; -----------------------------------------------------------------
;   Description  tests all libraries.
; -----------------------------------------------------------------
;   Usage        vertest()
; -----------------------------------------------------------------
;   Example   func("vertestl")
;             vertestl()
; -----------------------------------------------------------------
;   Author  Thomas Koetter, Sigbert Klinke, Marlene Mueller, 971210
; -----------------------------------------------------------------
;
proc()=vertestl()
  if (existglobal("ReportPath"))
    ReportPath=getglobal("ReportPath")+"/"
  else
    ReportPath=""
  endif
;
; Note: libs = list of ALL libs
;       not  = libs that can NOT be called IN BATCH
;
  libs=     "eiv"
  libs=libs|"finance"
  libs=libs|"gam"
  libs=libs|"glm"
  libs=libs|"gplm"
  libs=libs|"graphic"
  libs=libs|"hazreg"
  libs=libs|"kernel"
  libs=libs|"math"
  libs=libs|"metrics"
  libs=libs|"multi"
  libs=libs|"nn"
  libs=libs|"plm"
  libs=libs|"plot"
  libs=libs|"pp"
  libs=libs|"rpclib"
  libs=libs|"smoother"
  libs=libs|"stats"
  libs=libs|"times"
  libs=libs|"twave"
  libs=libs|"wavelet"
  libs=libs|"xclust"
  libs=libs|"xplore"
;
  status=string("could not be checked !!",1:rows(libs))
;
  notload=        "auto"
  notload=notload|"twave"
;
  nottest=        "nn"
  nottest=nottest|"rpclib"
;
;
  selhead = "Vertest for Libraries"
  selitem = "All"|libs
  status=string("not yet checked !!",1:(rows(selitem)-1))
;
  line = "================================================="
  report = line
;
  end = 0
  do
    sel = selectitem(selhead, selitem)
    end = (sum(sel).=0)
    switch
      case (sel[1])
        j=1
        while (j<rows(selitem))
          j=j+1
          libj=selitem[j]
          if (sum(notload==libj)>0)
            (" !!! "+libj+"test"+" NOT TESTED !!!")
            status[j-1]="can't be loaded in vertestl"
          else   
            library(libj)
            if ((exist(libj+"test")>0)&&(sum(nottest==libj)==0))
              exec( libj+"test()" )
              (" LIBRARY CHECK FOR "+libj+" FINISHED")
              status[j-1]="test finished ok"
            endif
            if (exist(libj+"test")<=0)
              (" !!! NO "+libj+"test"+" MACRO AVAILABLE !!!")
              status[j-1]="no test available"
            endif
            if (sum(nottest==libj)>0)
              (" !!! "+libj+"test"+" COULD NOT BE TESTED !!!")
              status[j-1]="can't be tested in vertestl, load ok"
            endif
          endif
/*
          line|(" CHECKING LIBRARY "+selitem[j])|line
          if (exist( selitem[j]+"test" )>0)
            exec( selitem[j]+"test()" )
            line|(" LIBRARY CHECK FOR "+selitem[j]+" FINISHED")|line
            status[j-1]=" test finished ok"
          else
            line|(" !!! NO "+selitem[j]+"test"+" MACRO AVAILABLE !!!")|line
            status[j-1]=" no test available"
          endif
*/
          tmp=substr(selitem[2:rows(selitem)]+"            ",1,11)
          tmp=tmp+string(" ... ",1:rows(selitem)-1)+status
          CurrentReport=line|tmp|line
          CurrentReport
        endo
        break
      case (sum(sel)==0)
        break
      default
        k=1
        while (k<rows(sel))
          k=k+1 
          j=k.*sel[k]
          if (j>0)
            libj=selitem[j]
            if (sum(notload==libj)>0)
              (" !!! "+libj+"test"+" NOT TESTED !!!")
              status[j-1]="can't be loaded in vertestl"
            else   
              library(libj)
              if ((exist(libj+"test")>0)&&(sum(nottest==libj)==0))
                exec( libj+"test()" )
                (" LIBRARY CHECK FOR "+libj+" FINISHED")
                status[j-1]="test finished ok"
              endif
              if (exist(libj+"test")<=0)
                (" !!! NO "+libj+"test"+" MACRO AVAILABLE !!!")
                status[j-1]="no test available"
              endif
              if (sum(nottest==libj)>0)
                (" !!! "+libj+"test"+" COULD NOT BE TESTED !!!")
                status[j-1]="can't be tested in vertestl, load ok"
              endif
            endif
/*
            library(selitem[j])
            line|(" CHECKING LIBRARY "+selitem[j])|line
            if (exist( selitem[j]+"test" )>0)
              exec( selitem[j]+"test()" )
              line|(" LIBRARY CHECK FOR "+selitem[j]+" FINISHED")|line
              status[j-1]=" test finished ok"
            else
              line|(" !!! NO "+selitem[j]+"test"+"MACRO AVAILABLE !!!")|line
              status[j-1]=" no test available"
            endif
*/
            tmp=substr(selitem[2:rows(selitem)]+"            ",1,11)
            tmp=tmp+string(" ... ",1:rows(selitem)-1)+status
            CurrentReport=line|tmp|line
            CurrentReport
          endif
        endo
        break
    endsw
  until(end)
  if (ReportPath!="")
    write(CurrentReport,ReportPath+"vertestb.report")
  endif
  CurrentReport
endp
;
vertestl()




