proc (op2) = opp(sigma)  	;Function to  be minimized in Case of Put
	optdata=getglobal("optdata")
	c=(optdata[1])
	s=(optdata[2])
	k=(optdata[3])
	r=(optdata[4])
	t=(optdata[5])
	q=(optdata[6])
        y = (log(s/k)+(r-q-sigma^2/2)*t)/(sigma*sqrt(t))
	op2 = (c-k*exp(-r*t)*cdfn(-y)+s*exp(-q*t)*cdfn(-y-sigma*sqrt(t)))^2
endp
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc (op1) = opc(sigma)		;Function to be minimized in Case of Call
	optdata=getglobal("optdata")
	c=(optdata[1])
	s=(optdata[2])
	k=(optdata[3])
	r=(optdata[4])
	t=(optdata[5])
	q=(optdata[6])
  	y = (log(s/k)+(r-q-sigma^2/2)*t)/(sigma*sqrt(t))
	op1 = (c-s*exp(-q*t)*cdfn(y+sigma*sqrt(t))+k*exp(-r*t)*cdfn(y))^2
endp
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc()=volatility(task)
; ---------------------------------------------------------------------
; Library        finance 
; ---------------------------------------------------------------------
; See_also    
; ---------------------------------------------------------------------
; Macro          volatility
; ---------------------------------------------------------------------
; Description    volatility calculates the implied volatility of a given option
; ---------------------------------------------------------------------
; Usage            volatility(task)
; Input       
;     Parameter    task
;     Definition      scalar: (=1) - without dividend, (=2) -  with
;                             continuously paid dividend, (=3) - with a
;                             fixed dividend at the end of T, (=4) - 
;                             if for exchange rate
; ---------------------------------------------------------------------
; Example        library("finance")
;                volatility(1)
; ---------------------------------------------------------------------
; Result         implied volatility of a given option
; ---------------------------------------------------------------------
; Author      D.Feldmann, S.Sperlich 970231
; ---------------------------------------------------------------------
valuestrs0 = "How many Options on Given Asset do You have?"
values0=0
v0=readvalue(valuestrs0, values0)
selheadline = "What kind of Options do you have?"
selitem = "Call"|"Put"
	sel = selectitem(selheadline, selitem)
	if (sel[1])
	   w=1
	endif
	if (sel[2])
	   w=0
	endif
optdata = matrix (6)		;determinant vector
vol = matrix(v0)	        ;vector of output
	values1=30|230|210|5.0|0.5
	v1=values1
	q = 0
;;;;;;start of loop to read determinant values
j=1
while (j.<(v0+1))
;input of basic parameters
	valuestrs1 = "Price of Option"|"Price of underlying asset"|"Exercise Price"|" Domestic Interest Rate per Year (%)"|"Time to Expiration (Years)"
	values1=v1
	v1=readvalue(valuestrs1, values1)
        s  = v1[2]
        ro = v1[4]*0.01
	v1[4]=log(0.01*v1[4]+1)
;input of additional parameters
	values2=0
	   if (task)
		switch
		case(task==2)	valuestrs2 = "Dividends per Year (%)" 
				q=readvalue(valuestrs2, values2)
				q=log(0.01*q+1)
				break
	        case(task==3)	valuestrs3 = "Dividend (fixed amount)" 
			        q=readvalue(valuestrs3, values2)
                                q=s*(1+ro)/(s*(1+ro)-q) -1
			        q=log(q+1)
		         	break
		case(task==4)   valuestrs4 = "Foreign interest rate per Year (%)" 
				q=readvalue(valuestrs4, values2)
				q=log(0.01*q+1)
				break
		endsw
	   endif
	optdata=v1|q
;optimization along sigma 
	putglobal("optdata")
	sigma = 0.1882			;starting value of sigma 
      if (w==1)
  	  sigma = nelmin(sigma,"opc", 1000, 1.0e-6) 	
	  vol[j] = sigma.minimum		
      endif 
      if (w==0)
          sigma = nelmin(sigma,"opp",1000,1.0e-6)
	  vol[j] = sigma.minimum
      endif
; input values of interest rate and dividend once defined shall be shown 
; in the readvalues-window once again to improve user's comfort
v1[4]= (exp(v1[4])-1)*100 	
q = (exp(q)-1)*100
j=j+1
endo
;;;;;;;;;;;;;;end of loop
;;;;;;;;;;;;;;output	  
sent=" The Implied Volatility of Your Option "
  if (task)	
		switch
		case(task==1) ence=" on Given Stock is " 
		break
		case(task==2) ence=" on Given Stock with cont. Dividends is" 
		break
		case(task==3) ence=" on Given Stock with fixed Dividend is" 
		break
		case(task==4) ence=" on Foreign Exchange is" 
		break
		endsw
  endif	
vol= string("%4.4f",vol)
;d= createdisplay(1,1)
;show(d,1,1,sent|ence|vol)
 lin=("-------------------------------------")
 aus= " "|lin|sent|ence|vol|lin|" "
 aus
endp

