; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         cart06
; ----------------------------------------------------------------------------
; Description   finds the cross-validated regression tree for 20% of
;               Boston Housing Data
; ----------------------------------------------------------------------------
     library("xclust")
     randomize(10)
     boston=read("bostonh")
     boston=paf(boston,uniform(rows(boston))<0.20)
     yvar=boston[,14]
     xvar=boston[,1:13]
     type=matrix(13)
     type[4]=0
     type[9]=0
     opt=cartsplitopt("minsize",1,"mindev",0,"mincut",8)
     cval=cartcv(xvar,yvar,type,opt,10)
     res=cval.lnumber~cval.alfa~cval.cv~cval.cvstd
     res=sort(res,1)
     res=res[1:12,]
     title=" no   alfa    cv   cvstd"
     restxt=title|string("%3.0f %6.2f %6.2f %6.2f", res[,1], res[,2], res[,3], res[,4])
     
     dd=createdisplay(2,2)
     show(dd, 1, 1, cval.lnumber~cval.alfa)
     setgopt(dd, 1, 1, "title","number obs. vs alpha")
     show(dd, 1, 2, cval.lnumber~cval.cv)
     setgopt(dd, 1, 2, "title","number obs. vs cv")
     show(dd, 2, 1, cval.lnumber~cval.cvstd)
     setgopt(dd, 2, 1, "title","number obs. vs cvstd")
     show(dd, 2, 2, restxt)
     