; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      eivknownvaru 
; ----------------------------------------------------------------------------
; Macro         eiv03
; ----------------------------------------------------------------------------
; Description   estimates the parameters of eiv model for corn data
;		with known variance of the measurement error
; ----------------------------------------------------------------------------
library("eiv")
z=read("corn.dat")
z=sort(z,3)
n=rows(z)
y=z[,1]
x=z[,2:3]
vv=inv(x'*x)*(x'*y); beta0=73.153 beta1=0.34404 
t=x[,2]
sigmau=57
gest=eivknownvaru(t,y,sigmau)
; the fit values
y1=vv[1]+vv[2]*t
y2=gest.beta0+gest.beta1*t  ;gest.beta1=0.42316 
          ;gest.beta0=67.564 
data=sort(t~y)
data1=t~y1
data2=t~y2
; output display
dds2=createdisplay(1,1)
part=grid(1,1,rows(t))'
color=0*matrix(rows(t))
color1=2*matrix(rows(t))
color2=5*matrix(rows(t))
layout=3*matrix(rows(t))
layout1=1*matrix(rows(t))
layout2=3*matrix(rows(t))
setmaskp(data,color,layout,9)
setmaskp(data1,color1,layout1,2)
setmaskp(data2,color2,layout2,3)
setmaskl(data,part,0,0,1)
setmaskl(data1,part,4,7,1)
setmaskl(data2,part,1,1,1)
show(dds2,1,1,data,data1,data2)
setgopt(dds2,1,1,"xlabel","Soil Nitrogen","title","Fitting via OLS and ME","ylabel","Yield")
; uncomment the following line for a PS picture
; print(dds2,"eivknownvarutu.ps")
