; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      tp/cafpe/plotloclin
; ----------------------------------------------------------------------------
; Macro         flts14
; ----------------------------------------------------------------------------
; Description   plots the nonparametric estimate of a
;               two-dimensional function of the conditional standard deviation 
;		for exchange rate returns and autocorrelation function of 
;               residuals
; ----------------------------------------------------------------------------
  pathcafpe	= "tp/cafpe/"	; path for CAFPE quantlets

; 	load required quantlets
  library("xplore")
  library("times")
  func("jarber")
  func(pathcafpe + "cafpeload"); load required XploRe files of CAFPE
  cafpeload(pathcafpe)    	
  setsize(640,480)
  setenv("outheadline","") 	; no header for each output file
  setenv("outlineno","")	; no numbering of output lines	
  
; 	set parameters
  x		= read("dmus58-300.dat");		
  y		= tdiff(x)
  xresid	= 0
  xdataln 	= "no"		; don't take logarithms
  xdatadif 	= "no"		; don't take first differences
  xdatastand	= "no"		; don't standardize data
  volat		= "no"		; compute cond. standard deviation
  lags      	= 1|3          	; lag vector for regression function
  h		= 0
  xsconst   	= 1e-100|1e-100	; 1e-100 for the lags which are varied
                                ; for those kept fixed it includes the
                                ; chosen constant
  gridnum   	= 30           	; number of gridpoints in one direction
  gridmax   	= 0.0015	; maximum of grid
  gridmin	= -0.0015	; minimum of grid

; compute optimal bandwidth and plot cond. mean for given lags
  { hplugin,hB,hC,xs,resid } = plotloclin(y,xresid,xdataln,xdatadif,xdatastand,volat,lags,h,xsconst,gridnum,gridmax,gridmin)
  "plug-in bandwidth for mean" hplugin 

; compute optimal bandwidth and plot cond. standard deviation for given lags
  lags 		= 2|6		; lags for cond. volatility
  xresid	= resid
  volat		= "resid"
  gridmax   	= 0.0008	; maximum of grid
  gridmin	= -0.0008	; minimum of grid

  { hplugin,hB,hC,xs,resid } = plotloclin(y,xresid,xdataln,xdatadif,xdatastand,volat,lags,h,xsconst,gridnum,gridmax,gridmin)
  "plug-in bandwidth for conditional volatility" hplugin

; 	diagnostics
  acfplot(resid)		; compute and plot autocorrelation function of residuals
  {jb,probjb,sk,k} = jarber(resid,1)
				; compute Jarque-Bera test for normality of residuals
; rotate view
  m = #(0.38269, 0.35355, -0.85355)
  m = m~#(-0.92387, 0.14646, -0.35356)
  m = m~#(1.5084e-05, 0.92388, 0.38269)
  setgopt(d1,1,1,"rotcos", m')

