; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      fastint
; ----------------------------------------------------------------------------
; Macro         gam09
; ----------------------------------------------------------------------------
; Description   estimates additive model using marginal integration
; ----------------------------------------------------------------------------
library("gam")
randomize(1234)
n = 100
d = 2
; generate a correlated design:
var = 1.0
cov = 0.4  *(matrix(d,d)-unit(d)) + unit(d)*var
{eval, evec} = eigsm(cov)
t = normal(n,d)
t = t*((evec.*sqrt(eval)')*evec')
g1    = 2*t[,1]
g2    = t[,2]^2 -mean(t[,2]^2)
y     = g1 + g2  + normal(n,1) * sqrt(0.5)
h1    = 0.5
h2    = 0.7
loc   = 0
gest  = fastint(t,y,h1,h2,loc)
library("graphic")
pic   = createdisplay(1,2)
dat11 = t[,1]~g1
dat12 = t[,1]~gest[,1]
dat21 = t[,2]~g2
dat22 = t[,2]~gest[,2]
setmaskp(dat12,4,4,8)
setmaskp(dat22,4,4,8)
show(pic,1,2,dat11,dat12)
show(pic,1,1,dat21,dat22)
