; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      hazdat hazrisk
; ----------------------------------------------------------------------------
; Macro         haz02
; ----------------------------------------------------------------------------
; Description   explains the use of quantlet atrisk which calculates the risk
;		set for a given time
; ----------------------------------------------------------------------------
 library("hazreg") 
 y = 2|1|3|2|4|7|1|3|2        ; hypothetical survival
 c = 3|1|5|6|1|6|2|4|5        ; hypothetical censoring
 t = min(y~c,2)               ; censored time             
 delta = (y<=c)               ; censoring indicator            
 {data,ties} = hazdat(t,delta) 
 atrisk = hazrisk(data,6)     ; risk set at observation 6             
 atrisk