; -----------------------------------------------------------------
; Library        REGR
; -----------------------------------------------------------------
;   Macro        regr1
; -----------------------------------------------------------------
;   Description  Linear Regression with linreg and grlinreg.
; -----------------------------------------------------------------
  library("graphic")          ; reads the library graphic
  library("stats")            ; reads the library stats
;
  z=read("westwood.dat")      ; reads the data
  z                           ; shows the data
  x=z[,2]                     ; puts the x-data into x
  y=z[,3]                     ; puts the y-data into y
;
  {beta,bse,bstan,bpval}=linreg(x,y)
           ; computes the linear regression and returns the 
           ;    variables of beta, bse, bstan and bpval
  beta     ; shows the value of beta
;
  yq=(beta[1]+beta[2]*x[1:10]) ; creates a vector with the 
                               ;    estimated values of y
  data=sort(x~y)               ; creates object with the data set
  data=setmask(data,"blue","cross")
                               ; creates a graphical object for 
                               ;    the data points
  rdata=sort(x~yq)             ; creates an object with yq
  rdata=setmask(rdata,"line","red")
                               ; sets the options for the 
                               ;    regression function by linreg
  regrdata=grlinreg(data,4)    ; creates the same graphical 
                               ;    object directly from the data 
  regrdata=setmask(regrdata,"line","red")
                               ; sets options for the regression 
                               ;    function by grlinreg
  linregplot=createdisplay(1,2); creates display with 2 windows
  show(linregplot,1,1,data,rdata)
                               ; shows rdata in the 1st window
  show(linregplot,1,2,data,regrdata)
                               ; shows regrdata in the 2nd window
  setgopt(linregplot,1,1,"title","linreg")
                               ; sets the title of the 1st window
  setgopt(linregplot,1,2,"title","grlinreg")
                               ; sets the title of the 2nd window
