proc (res) = SPPPinit (pp, xl, xu, yl, yu, fac)
;
; -----------------------------------------------------------------------
; Library      spatial 
; -----------------------------------------------------------------------
; See_also     SPPPinitrandom SPPPsetregion SPPPgetregion
;              SPPPkfn SPPPpsim SPPPstrauss SPPPssi SPPPkenvl SPPPkaver
; -----------------------------------------------------------------------
; Macro        SPPPinit
; -----------------------------------------------------------------------
; Description  Creates a point process object and calls SPPPsetregion to
;              set the rectangular spatial domain.
; -----------------------------------------------------------------------
; Usage        ppobj = SPPPinit (pp, xl, xu, yl, yu, fac)
; Input
;   Parameter  pp
;   Definition n x 2  -  matrix of x and y coordinates of locations 
;   Parameter  xl
;   Definition scalar -  lower limit in x-direction of the domain rectangle
;   Parameter  xu
;   Definition scalar -  upper limit in x-direction of the domain rectangle
;   Parameter  yl
;   Definition scalar -  lower limit in y-direction of the domain rectangle
;   Parameter  yu
;   Definition scalar -  upper limit in y-direction of the domain rectangle
;   Parameter  fac
;   Definition scalar -  used to rescale all coordinates, i.e., to divide all
;                       coordinates by fac
; Output
;   Parameter  res
;   Definition list  -   consisting of components 
;                       pp, area, type --
;   Parameter  pp
;   Definition n x 2  -  input matrix pp (scaled by fac)
;   Parameter  area
;   Definition 4 x 1  -  vector consisting of xl, xu, yl, and yu
;                       (all scaled by fac)
;   Parameter  type
;   Definition string -  "PP"
; -----------------------------------------------------------------------
; Notes        C-Code from Venables, Ripley (1999) forms the basis of 
;              this quantlet. Also check this reference for more details.
; -----------------------------------------------------------------------
; Example      ; load the spatial statistics library
;	       library ("spatial")
;              ; read a spatial data set
;	       pines = read ("pines.dat")
;	       ; initialize a point process
;  	       pinesobj = SPPPinit (pines, 0, 96, 0, 100, 10)
; -----------------------------------------------------------------------
; Result       A point process object suitable for use in SPPPkfn.
; -----------------------------------------------------------------------
; Reference    Venables, W. N., Ripley, B. D. (1999): Modern Applied
;              Statistics with S-Plus, Third Edition, Springer, New York 
; -----------------------------------------------------------------------
; Link         ../tutorials/spatialstart.html Spatial statistics tutorial
; -----------------------------------------------------------------------
; Author       Juergen Symanzik, 000725
; -----------------------------------------------------------------------
;
  error (exist("pp") != 1, "pp must be a matrix")
  error (cols(pp) < 2, "pp must have at least 2 columns")
  error (exist("xl") != 1, "xl must be numeric")
  error (exist("xu") != 1, "xu must be numeric")
  error (exist("yl") != 1, "yl must be numeric")
  error (exist("yu") != 1, "yu must be numeric")
  error (exist("fac") != 1, "fac must be numeric")
  error (fac <= 0, "fac must be > 0")
  ;
  ;
  pp = pp / fac
  xl = xl / fac
  xu = xu / fac
  yl = yl / fac
  yu = yu / fac
  area = xl | xu | yl | yu
  type = "PP"
  res = list (pp, area, type)
  SPPPsetregion (res)
endp
