proc () = SPPPinitrandom (rstart)
;
; -----------------------------------------------------------------------
; Library      spatial 
; -----------------------------------------------------------------------
; See_also     SPPPinit SPPPsetregion SPPPgetregion
;              SPPPkfn SPPPpsim SPPPstrauss SPPPssi SPPPkenvl SPPPkaver
; -----------------------------------------------------------------------
; Macro        SPPPinitrandom
; -----------------------------------------------------------------------
; Description  Resets the random number generator for point processes.
; -----------------------------------------------------------------------
; Usage        SPPPinitrandom (rstart)
; Input
;   Parameter  rstart
;   Definition scalar  - root for random number generator
; Output
;   None
; -----------------------------------------------------------------------
; Notes        C-Code from Venables, Ripley (1999) forms the basis of 
;              this quantlet. Also check this reference for more details.
; -----------------------------------------------------------------------
; Example      ; load the spatial statistics library
;	       library ("spatial")
;              ; read a spatial data set
;	       pines = read ("pines.dat")
;	       ; initialize a point process
;  	       pinesobj = SPPPinit (pines, 0, 96, 0, 100, 10)
;  	       ; reset random number generator
;  	       SPPPinitrandom (0)
;  	       ; create random point processes
;  	       sppsim = SPPPpsim (100, 72)
; -----------------------------------------------------------------------
; Result       The root for the random number generator for point 
;              processes is set to rstart - thus allowing to repeat
;              a particular sequence of random numbers.
; -----------------------------------------------------------------------
; Reference    Venables, W. N., Ripley, B. D. (1999): Modern Applied
;              Statistics with S-Plus, Third Edition, Springer, New York 
; -----------------------------------------------------------------------
; Link         ../tutorials/spatialstart.html Spatial statistics tutorial
; -----------------------------------------------------------------------
; Author       Juergen Symanzik, 000725
; -----------------------------------------------------------------------
;
  error (exist("rstart") != 1, "rstart must be numeric")
  ;
  ;
  os = getenv ("os")
  if (os == "windows")
    d = dlcall ("_VR_ppinitrandom", rstart)
  else  
    ; Unix
    d = dlcall ("VR_ppinitrandom", rstart)
  endif
  ;
endp
