proc () = SPPPsetregion (pp)
;
; -----------------------------------------------------------------------
; Library      spatial 
; -----------------------------------------------------------------------
; See_also     SPPPinit SPPPinitrandom SPPPgetregion
;              SPPPkfn SPPPpsim SPPPstrauss SPPPssi SPPPkenvl SPPPkaver
; -----------------------------------------------------------------------
; Macro        SPPPsetregion
; -----------------------------------------------------------------------
; Description  Sets the rectangular spatial domain for spatial point
;              pattern analysis.
; -----------------------------------------------------------------------
; Usage        SPPPsetregion (pp)
; Input
;   Parameter  pp
;   Definition list  -   consisting of area (and possibly other components) - 
;                       either previously created by a call to SPPPinit or
;                       created from scratch
; Output
;   None
; -----------------------------------------------------------------------
; Notes        C-Code from Venables, Ripley (1999) forms the basis of 
;              this quantlet. Also check this reference for more details.
; -----------------------------------------------------------------------
; Example      ; load the spatial statistics library
;	       library ("spatial")
;              ; read a spatial data set
;	       pines = read ("pines.dat")
;	       ; initialize a point process
;  	       pinesobj = SPPPinit (pines, 0, 96, 0, 100, 10)
;  	       ; explicitly set region (although this is already
;              ; done in SPPPinit)
;  	       SPPPsetregion (pinesobj)
; -----------------------------------------------------------------------
; Result       Initializes internal variables for further use in 
;              point process quantlets.
; -----------------------------------------------------------------------
; Reference    Venables, W. N., Ripley, B. D. (1999): Modern Applied
;              Statistics with S-Plus, Third Edition, Springer, New York 
; -----------------------------------------------------------------------
; Link         ../tutorials/spatialstart.html Spatial statistics tutorial
; -----------------------------------------------------------------------
; Author       Juergen Symanzik, 000725
; -----------------------------------------------------------------------
;
  error (exist("pp") != 9, "pp must be a list")
  error (comp(pp, "area") == 0, "pp must contain component area")
  error (rows(pp.area) < 4, "pp.area must have at least 4 rows")
  ;
  ;
  regerror = -1
  ;
  os = getenv ("os")
  if (os == "windows")
    d = dlcall ("_VR_ppset", pp.area, regerror)
  else  
    ; Unix
    d = dlcall ("VR_ppset", pp.area, regerror)
  endif
  ;
  error (regerror == 0, "SPPP region not properly initialized -- use SPPPinit or SPPPsetregion first")
endp
