
proc (y) = acf (x) 
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  pacf, fft, invfft
; ----------------------------------------------------------------------
;   Macro	  acf
; ----------------------------------------------------------------------
;   Description   computes the autocorrelation function for time series
; ----------------------------------------------------------------------
;   Usage         y = acf(x)
;   Input 
;     Parameter   x 
;     Definition  vector
;   Output
;     Parameter   y
;     Definition  vector
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize (0)
;                 x=normal(100)
;		              a1=acf(x)
;                 a1[1:5]
; ----------------------------------------------------------------------
;   Result        Contents of _tmp   
;                 [1,]        1 
;                 [2,] -0.15902 
;                 [3,] -0.12114 
;                 [4,]  0.29794 
;                 [5,] -0.021693 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, 961028
; ----------------------------------------------------------------------
  n = rows(x) 
  x = x-mean(x)
  p = log(n) / log(2)
  p = rint(exp(log(2)*ceil(p)))            ; next power of 2 
  if (n != p)
    x = x|(matrix(p-n)-1)                  ; append series 
  endif
  x=x~(matrix(p).*0)
  ftr = fft(x)                             ; fourier transform
  peri = (sum((ftr.*ftr)')/p)'            ; periodogram
  peri=peri~matrix(p).*0
  y1 = invfft(peri)./sum(x[,1]^2).*p      ; autocorr function
  y = y1[1:n,1]
endp
 
