proc(p) = aerlb(x1, x2)
; ----------------------------------------------------------------------
; Library 	  xclust
; ----------------------------------------------------------------------
;  See_also	discrim distance lpdist
; ----------------------------------------------------------------------
;   Macro	  aerlb
; ----------------------------------------------------------------------
;   Description   computes the Lachenbruch-Mickey unbiased estimate of the actual discrimination error rate
; ----------------------------------------------------------------------
;   Usage         p = aerlb(x1, x2)
;   Input 
;     Parameter   x1 
;     Definition  n1 x p matrix (sample 1)
;     Parameter   x2 
;     Definition  n2 x p matrix (sample2)
;   Output
;     Parameter   p
;     Definition  2 x 1 vector, the estimate of the actual error rate (AER)
; ----------------------------------------------------------------------
;   Example       library("xplore")
;	         library("xclust")
;                        x1=normal(100, 2)
;	         x2 = normal(50, 2) + 0.8  	
;                        p = aerlb(x1, x2)
;                        p
; ----------------------------------------------------------------------
;   Result
;                 [1,] 0.250000 0.280000   
;               
; ----------------------------------------------------------------------
;   Author      Wolfgang Hrdle, 980221
; ----------------------------------------------------------------------
// step 1 of lachenbruch-mickey procedure
  n1 = rows(x1)
  n2 = rows(x2)	
  d = discrim(x1[2:n1,], x2, x1[1,]')
//  step 2 of lachenbruch-mickey procedure
  i = 2
  while (i <= (n1-1))
	d = d|discrim(x1[1:(i-1),]|x1[i+1:n1,], x2, x1[i,]')
	i = i+1
  endo
d= d|discrim(x1[1:(n1-1),], x2, x1[n1,]')
p1 = sum(d[,1].>=d[,2])./n1
//  step 3 of lachenbruch-mickey procedure
  d = discrim(x1, x2[2:n2,], x2[1,]')
//  step 4 of lachenbruch-mickey procedure
  i = 2
  while (i <= (n2-1))
	d = d|discrim(x1, x2[1:(i-1),]|x2[i+1:n2,], x2[i,]')
	i = i+1
  endo
  d= d|discrim(x1, x2[1:(n2-1),], x2[n2,]')
  p2 = sum(d[,1].<d[,2])./n2
  p = p1~p2
endp
