proc(j)=agen(a, di, ord,typ)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  bgen
; ----------------------------------------------------------------------
;   Macro	  agen
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for VAR models
; ----------------------------------------------------------------------
;   Usage         j = agen(a, di, ord,typ)
;   Input 
;     Parameter   a 
;     Definition     vector
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   typ 
;     Definition     integer, describing the model type
;   Output
;     Parameter   j
;     Definition     matrix
; ----------------------------------------------------------------------
;   Example       library("multi")
;                 y = agen(zeros(1,4),2,2,1)
;                 y
; ----------------------------------------------------------------------
;   Result        Contents of y
;                 [1,] 0        0        0        0 
;                 [2,] 1        0        0        0 
;                 [3,] 0        1        0        0
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971027
; ----------------------------------------------------------------------
if (typ==6)
   if (ord==1)
     j=a|zeros(di,2*di)
   else
     if (ord>=2)
j=a|( eye(di*(ord-1))~zeros(di*(ord-1),di*(ord+1)))
j=j|(zeros(di*ord,di*ord)~(zeros(di,di*ord)|(eye(di*(ord-1))~zeros(di*(ord-1),di))))
     else
       j=0
     endif
   endif
else
   if (ord==1)
    j=a
   else
    if (ord>=2)
      j=a|(eye(di*(ord-1))~zeros(di*(ord-1),di))
     else
      j=0
     endif 
   endif
endif
endp
