proc(a)=andrews(x,y,id,b,h)
;------------------------------------------------------------------------
; Library	metrics
;------------------------------------------------------------------------
; See_also	heckman select sssm  powell wade  gennorm
;------------------------------------------------------------------------
; Macro		andrews
;------------------------------------------------------------------------
; Description   andrews calculates the semiparametric estimator proposed 
;		by Andrews and Schafgans (1994) of the intercept coefficients of the outcome 
;		equation in a sample selection model.		
; ----------------------------------------------------------------------- 
; Usage		a =  andrews(x,y,id,b,h)                 
;------------------------------------------------------------------------
; Input                                                                     
; Parameter	x  
; Definition		n x M  regressor matrix. WARNING: x may not contain a vector of ones! 
; Parameter	id  
; Definition		n x 1  vector containing the estimated index of the first-step selection equation.
; Parameter	y
; Definition		n x 1  matrix containing n observ. of the dependent variable                                      
; Parameter	b     
; Definition		M x 1 	vector of estimated slope coefficients                 
; Parameter	h     
; Definition	        scalar,  the bandwidth       
; Output                                                                     
; Parameter	a     
; Definition		scalar, 	estimated intercept coefficient                 
; ------------------------------------------------------------------------
;  Example 	
;		library("xplore")
;		library("metrics")
;		randomize(66666)
; 		n	= 200				; sample size
;		ss1	= #(1,0.9)~#(0.9,1)		; covariance matrix of error terms
;		g	= #(1)				; true coefficient of decision equation
;		b	= #(-9, 1)			; true intercept and slope of outcome equation
;		u	= gennorm(n, #(0,0), ss1)	; generate realizations of joint distribution of error terms
;		ss2     = #(1,0.4)~#(0.4,1)		; covariance matrix of regressors
;		xz      = gennorm(n, #(0,0), ss2)       ; generate realizations of joint distribution of regressors
;		z       = xz[,2]			; regressor of decision equation
;		q       = (z*g+u[,1].>=0)		; generate binary dependent variable of decision equation
;		hd	= 0.1*(max(z) - min(z))		; bandwidth for dwade procedure
;		d	= dwade(z,q,hd)*(2*sqrt(3)*pi)	; dwade estimate * scaling factor
;		id	= z*d				; estimated first-step index
;		hp      = 0.2*(max(id) - min(id))	;  bandwidth for powell procedure
;		x	= matrix(n)~xz[,1]		; regressors for outcome equation
;		y       = x*b+u[,2]			; dependent variable for outcome equation
;		zz	= paf(y~x~id, q)		; impose censored sampling
;		y	= zz[,1]
;		x	= zz[,3:(cols(zz)-1)]
;		id	= zz[,cols(zz)]		
;		bhat	= powell(x,y,id,hp)
;		ha	= quantile(id, 0.7)
;		a	= andrews(x,y,id,bhat,ha)
;		a					; estimated intercept
; -----------------------------------------------------------------
;   Result    estimated intercept of the outcome equation of a semiparametric
;             sample selection model according to Andrews and Schafgans (1994)
; -----------------------------------------------------------------
; Author	akw,961011 
; ----------------------------------------------------------------------------
	u=id.-h			; (-index) - smoothing parameter
	l1=u.>=0		; =1 if (index) > smoothing parameter
	l2=u.>=3		;=1 if (index) > 3 ("3" is "b" in the paper)
	l3=matrix(rows(y))	;vector of "1"s
	l4=1-l2			;=1 if (index) < 3
        s=1-exp(-(u.*l1)./(3-(u.*l1)))  ;weight function s=1-exp(-u/(b-u)),
	s=s.*l4			; sets s=0 if (-index) > 3
	s=s+l2			; sets s=1 if (-index) > 3
	l5=s.<>0		; =1 if s > 0
	xbeta=x*b		;slopes * x for stayer`s earnings equation
	xx=(y-xbeta).*s		; numerator
	a=sum(xx)/sum(s)	;sum(xx)/sum(s) is alpha estimator
	endp