proc()=ann(x, y, t, varname)               
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     nnrnet nnrpredict 
; -----------------------------------------------------------------------
; Macro        ann
; -----------------------------------------------------------------------
; Description  is a tool to run a feed-forward neural network
; -----------------------------------------------------------------------
; Usage        ann (x, y, t {, vn})
; Input
;   Parameter  x
;   Definition n x p matrix input variables 
;   Parameter  y
;   Definition n x q matrix output variables
;   Parameter  t
;   Definition n x 1 vector of sets (0=training, 1=test, 2=validation)
;   Parameter  vn
;   Definition p x 1 vector of variable names (unused)
; Output
; -----------------------------------------------------------------------
; Example     x = read("kredit1")
;             t = read("tkredit")
;             y = x[,1]
;             x = x[,2:21]
;             x = (x-min(x))./(max(x)-min(x))
;             ANN (x, y, t)
; -----------------------------------------------------------------------
; Result      runs a user specified neural network for the kredit data of 
;             Fahrmeier and Hammerle.
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, Janet Grassmann,  951231; Sigbert Klinke, 961121
; Link        http://www.wiwi.hu-berlin.de/~sigbert/index.html#dp007 Visualization and Implementation of Feedforward Neural Networks
; -----------------------------------------------------------------------
  if (exist(varname).<>1)               
     varname = string("X%.0f", 1:cols(x))               
    varname = varname|string("Y%.0f", 1:cols(y))               
  endif               
  if (existglobal("DisplaySize"))
    ds = getglobal("DisplaySize")
  else
    ds = 640
  endif
  axesoff()
  setsize (ds, ds)
  nndisp = createdisplay(3,1) 
  setfractions (nndisp, 1|4|1, 1)              
  mnumain = "Generate"|"Run"|"Run CV"|"CV Decay"|"Network parameter"|"View Result"
  mnupar = "Error"|"Optimize"|"Init"|"Decay"|"Restart"|"WeiDist"|"Visualization"|"Read"|"Write"
  mnures = "View Wei"|"View Unit"|"View Res"|"Regress"|"Class"
  v = (cols(x)~0)|(cols(y)~2)   
  netid = string ("FFN    : %.0f-%.0f", cols(x), cols(y)) 
  {w, u, m}=nnlayer(v, varname)             
  w   = w~normal(rows(w))               
  dec = 0.001               
  opt = 0               
  err = 1               
  ran = -1               
  res = 1               
  weidist = "weidist1" 
  sel = 1      
  vmeth = 2
  while (sum(sel))             
    nninfo(nndisp, netid, dec, opt, err, ran, res)       
    sel = selectitem ("nn", mnumain)               
    if (sel[1])           ; Generate               
      {w, u, m, netid} = gennet(cols(x), cols(y), ran, varname)               
    endif
    if (sel[2])       ; Run               
      {xv, w, s} = runnet(nndisp, w, u, m, x, y, t, dec, opt, err, res, 1, weidist, vmeth)
    endif
    if (sel[3])       ; Run CV               
      {xv, w, s} = runcv(nndisp, w, u, m, x, y, t, dec, opt, err, res, 1, weidist, vmeth)
    endif
    if (sel[4])       ; CV Decay           
      {xv, w, s, dec}=cvdec(nndisp, w, u, m, x, y, t, dec, opt, err, res, 1, weidist, vmeth)
      ;show (xv s2d1)           
    endif
    if (sel[5])       ; network parameters
      selpar = 1
      while (sum(selpar)) 
        selpar = selectitem("nn parameter", mnupar)
        if (selpar[1])  ; Error
          mnu2 = "Quadratic"|"Likelihood"
          sel2 = 0
          while (sum(sel2)<>1)
            sel2 = selectitem ("error", mnu2)
          endo
          err  = sum((1:2).*sel2)-1               
        endif
        if (selpar[2])       ; Optimize               
          mnu2 = "Stochastic"|"Annealing"|"QApprox"
          sel2 = 0
          while (sum(sel2)<>1)
            sel2 = selectitem ("optim", mnu2)
          endo
          opt  = sum((1:3).*sel2)-1               
        endif
        if (selpar[3])       ; Init               
          ran  = readvalue("Initialize Net:", (-1))               
          if (cols(w).>3)               
            str = string ("Net (0-%.f):", cols(w)-3)               
            j   = readvalue(str, 0)               
            w[,3+j] = weinit(w, ran)               
          else               
            w[,3] = weinit(w, ran)               
          endif    
        endif           
        if (selpar[4])       ; Decay               
          dec = readvalue("Weight Decay:", dec)               
        endif
        if (selpar[5])       ; Restart               
          res = readvalue("Restart:", 10)            
        endif
        if (selpar[6])       ; WeiDist        
          mnu2 = "max(w)-w"|"1/w"|"2 max(w) - w"
          sel2 = selectitem ("dist", mnu2)
          if (sel2[1])       
            weidist = "weidist1"       
          endif
          if (sel2[2])       
            weidist = "weidist2"       
          endif       
          if (sel2[3])       
            weidist = "weidist3"       
          endif       
        endif
        if (selpar[7])       ; Visualization
          fn = string ("Dimension (max. %.0f)", rows(u))
          vmeth = floor(readvalue (fn, vmeth))
          ;if (vmeth.<2)
            vmeth = 2
          ;endif
        endif
        if (selpar[8])       ; Read               
          fnv = readvalue ("Filename (no ext):", 0)    
          fn = string ("fn%.0f", fnv)  
          w  = read (fn+".wei")               
          u  = read (fn+".unt") ; "ddtm")           
          k  = read (fn+".par") ; "d")           
          m  = u[,3]
          if (sum(m).=0)
            m = 2*(u[,4].=110)+4.*(u[,4].=45)+3.*(u[,4].=95)
          endif
          u   = u[,1:2]           
          dec = k[1,1]           
          opt = k[2,1]           
          err = k[3,1]           
          ran = k[4,1]           
          res = k[5,1]           
          readshow (nndisp, w, u, x, y, dec, m, t, err, weidist, vmeth)           
        endif
        if (selpar[9])       ; Write           
          fnv = readvalue ("Filename (no ext):", 0)           
          fn = string ("fn%.0f", fnv)           
          write (w, fn+".wei")           
          write (u~m, fn+".unt")           
          k = dec|opt|err|ran|res           
          write (k, fn+".par")           
        endif
      endo
    endif
    if (sel[6])        ; View Results
      selres = 1
      while (sum(selres)) 
        selres = selectitem ("nn results", mnures)
        if (selres[1])       ; View Weight      
          weidisp = createdisplay(2,1)
          grw1 = grdotd(w[,3])         
          show (weidisp, 1, 1, grw1)
          setheadline (weidisp, 1,1, "Distribution of training weights")
          grw2 = grdotd(w[,4]) 
          show (weidisp, 2, 1, grw2)
          setheadline (weidisp, 1,1, "Distribution of test weights")
          w                ;edit(w)
        endif
        if (selres[2])       ; View Unit             
          u                ;edit (u)
        endif
        if (selres[3])       ; View Res               
          if (cols(w).>3)               
            str = string ("Net (0-%.f):", cols(w)-3)               
            j   = readvalue(str, 0)               
            wr  = w[,1:2]~w[,3+j]       
          else               
            wr = w               
          endif               
          yr = nnfunc (wr, u, x)               
          yres = sort(t~abs(y-yr)) 
          yres              
        endif
        if (selres[4])       ; Regress          
          resreg(w, u, x, y, t)          
          ;writecon(27)               
          ;display(nndisp)               
        endif
        if (selres[5])       ; Class          
         resclass(w, u, x, y, t)          
         ;writecon(27)               
         ;display(nndisp)               
        endif           
      endo
    endif
  endo           
endp           
