proc(summ)=arbitrage()
; -----------------------------------------------------------------
; Library        finance
; -----------------------------------------------------------------
;  See_also      callbull
; -----------------------------------------------------------------
;   Macro        arbitrage
; -----------------------------------------------------------------
;   Description  calculates an arbitrage table considering
;                put and calls with the same strike price
; -----------------------------------------------------------------
;   Usage        sum = arbitrage()    
;   Input
;   Output                                                           
;     Parameter   sum
;     Definition      arbitrage table as a string matrix 
; -----------------------------------------------------------------
;   Example   library("finance")
;             sum=arbitrage()
;             sum
; -----------------------------------------------------------------
;   Result    table of arbitrage, where
;     Call_price is the vector of call prices
;     Put_price  is the vector of put prices
;     Basis      is the vector of basis prices
;     Stock_flow is the amount we pay/get for buying/selling stock
;     Call_flow  is the amount we pay/get for buying/selling call option
;     Put_flow 	 is the amount we pay/get for buying/selling put option
;     Bank_flow  is the investment to/loan from a bank
;     Arbitrage  is the vector of arbitrage gains/losses
; -----------------------------------------------------------------
;   Author    Sperlich, Trost 970507
; -----------------------------------------------------------------

        x = 17|0.0302|587.3|575|625|2                   	;example values
        st =    "Days to maturity"|"Interest rate"		;interest rate = one-month forward interest rate between banks
        st = st |"Stock price"|"Lowest basis price"
        st = st |"Highest basis price"|"Number of steps (<=5)"
        x = readvalue(st, x)
	n = x[6]
	t = "Please input call prices."			
	i = 1
	while(i<(n+1))
  	  t = t|" "  
          i=i+1
	endo
	C = 3*matrix(n+1)
	C = readvalue(t,C)				;vector of call values
	v = "Please input put prices."	
	i = 1
	while(i<(n+1))
  	  v = v|" "
          i=i+1
	endo
	P = 15.9*matrix(n+1)
	P = readvalue(v,P)				;vector of put values
        S = x[3]*matrix(n+1)
;Calculation
	w = (x[5]-x[4])/n
        B=aseq(x[4],(n+1),w)
	A = B./(1+x[2]*x[1]/360)			;investment / loan
	logi = P.>C					;vector of logical values
	G1 = P.+S.-C.-A					;vector for P>C
	G2 = C.+A.-P.-S					;vector for C>P
        G = G1.*logi+G2.*(1-logi)			;vector for arbitrage gains / losses
	C1 = -C.*logi+C.*(1-logi)			;cash flow call
	P1 = P.*logi-P.*(1-logi)			;cash flow put
	S1 = S.*logi-S.*(1-logi)			;cash flow stock
	A1 = -A.*logi+A.*(1-logi)			;cash flow investment/loan
;Output
	e=C~P~B~S1~C1~P1~A1~G
        j=0
        while (j<cols(e))
	  if(j==0)
	     head1 = ("Stock price: ")+(string("%10.2f",x[3]))
	     head2 = ("Interest rate: ")+(string("%10.4f",x[2]))
	     head3 = ("Days to maturity: ")+(string("%5.2f",x[1]))
             headtxt = head1|head2|head3
          endif
          j=j+1
          if (j==1)
            summtxt=string("%9.2f",e[,1])
            else
            summtxt=summtxt+string("%10.2f",e[,j])
          endif
        endo
        summ=      ("Call_price "|"----------")	;vector of call prices
        summ= summ+(" Put_price "|"----------")	;vector of put prices
        summ= summ+(" Basis "|"----------")  ;vector of basis prices
        summ= summ+(" Stock_flow "|"----------") ;buying/selling stock
        summ= summ+(" Call_flow "|"----------")	;buying/selling call option
	summ= summ+(" Put_flow "|"----------")	;buying/selling put option
	summ= summ+(" Bank_flow "|"----------")	;bank_flow=investment to/loan from a bank
	summ= summ+(" Arbitrage "|"--------------") ;vector of arbitrage gains/losses
        summ= " "|summ|summtxt|" "
     summ=headtxt|summ
 endp
