proc(y,wnv) = armacls(zz,p,q)
; -------------------------------------------------------------------
; Library	  times
; -------------------------------------------------------------------
;  See_also	  armalik
; -------------------------------------------------------------------
;   Macro 	  armacls
; -------------------------------------------------------------------
;   Description	  estimates an autoregressive moving average 
;   		  process with mean zero by conditional least squares
; -------------------------------------------------------------------
;   Usage	  {y,wnv} = armacls(x,p,q)
;   Input 
;     Parameter   x
;     Definition  n-vector, the process
;     Parameter   p
;     Definition  scalar, the autoregression order
;     Parameter   q
;     Definition  scalar, the moving average order
;   Output
;     Parameter   y
;     Definition  list containing 1. p+q-vector, the estimated 
;                 parameters, 2. the number of iterations, and 3. a 
;                 0-1 scalar indicating convergence
;     Parameter   wnv
;     Definition  scalar, the estimate of the white noise variance
; -------------------------------------------------------------------
;   Example       library("times")
;                 randomize(0)
;                 x = genarma(0.7,0.3,normal(500))
;                 {y,wnv}=armacls(x,1,1)
;                 y{1}
; -------------------------------------------------------------------
;   Result        Contents of minimum 
;                 [1,]  0.70623 
;                 [2,]  0.27249 
; -------------------------------------------------------------------
;   Author        Christian Hafner, 960906
; -------------------------------------------------------------------
  putglobal("zz")
  q = rint(q)     ; moving average order
  p = rint(p)     ; autoregression order
  error((p<1)&&(q<1), "at least one of p and q must be positive")
  putglobal("p")
  n = rows(zz)
  start = normal(p+q)./(p+q)	; random starting values
                  ; minimization of squared residuals:
  y = nelmin(start,"armapq",200,1e-5)
  ssr = getglobal("ssr")
  wnv = ssr/(n-p-q)	; estimate of white noise variance	
endp
;--------------------------------------------------------------------
proc(ssr) = armapq(a)
  zz = getglobal("zz")
  p = getglobal("p")
  q = rint(rows(a)-p)
  switch
    case (p<=0)	     ; the MA(q) case
      p = 1
      phi = 0
      theta = a
      break
    case (q<=0)	     ; the AR(p) case
      q = 1
      theta = 0
      phi = a
      break
    case ((q>0) &&(p>0))  ; the ARMA(p,q) case
      phi = a[1:p]
      theta = a[p+1:p+q]
      break
  endsw
  n = rows(zz)  
  ma = zz            ; initialize MA-vector for generating residuals 
  m = max(p|q)
  u = matrix(n)	     ; the residuals
  u[1] = zz[1]
  i = 1
  while(i<=m)        ; loop for starting values
    ma[i+1] = zz[i+1] - phi[1:min(i|p)]' *  zz[i:max(1|i-p+1)]
    u[i+1] = ma[i+1]-theta[1:min(i|q)]'*u[i:max(1|i-q+1)]
    i = i+1
  endo
  j = 1	             ; loop for moving average
  while(j<=p)
    ma[m+2:n] = ma[m+2:n]-phi[j].*zz[m+2-j:n-j]
    j = j+1
  endo
  u = genar(ma, u[1:q], -theta)	; generation of residuals
  ssr = sum(u.^2)    ; the sum of squared residuals
  putglobal("ssr")
endp
