proc(a,stderr,covp,s2) = armalik(zz)
; -----------------------------------------------------------------
; Library	  times
; -----------------------------------------------------------------
;  See_also	  armacls
; -----------------------------------------------------------------
;   Macro 	  armalik
; -----------------------------------------------------------------
;   Description	  estimates an ARMA(1,1) process with mean zero by 
;                 maximum likelihood using the innovation algorithm
; -----------------------------------------------------------------
;   Usage	  y = armalik(x)
;   Input 
;     Parameter   x
;     Definition  n-vector, the process
;   Output
;     Parameter   y
;     Definition  list containing 1. the estimated parameters, 2. 
;                 the corresponding asymptotic standard deviations,  
;                 3. the asymptotic covariance, and 4. the 
;                 estimate of the white noise variance
; -----------------------------------------------------------------
;   Example       library("times")
;                 randomize(0)
;                 x = genarma(0.7,0.3,normal(100))
;                 {a, stderr, covp, s2} = armalik(x)
;                 a
; -----------------------------------------------------------------
;   Result        Contents of a 
;                 [1,]  0.87487 
;                 [2,] -0.069252 
; -----------------------------------------------------------------
;   Author        Christian Hafner, 960906
; -----------------------------------------------------------------
  putglobal("zz")
  n=rows(zz)
  start=normal(2)./3      ; starting values
  a=nelmin(start,"innova",50,1e-5)  ; likelihood maximization
  a=a{1}
  phi=a[1]                ; autoregression parameter
  theta=a[2]              ; moving average parameter
;   asymptotic standard deviations :
  stdphi=(1+phi*theta)/(phi+theta)*sqrt(1-phi^2)/sqrt(n) 
  stdtheta=(1+phi*theta)/(phi+theta)*sqrt(1-theta^2)/sqrt(n)
  stderr=stdphi|stdtheta
;   asymptotic covariance of phi and theta:
  covp=-(1/n)*(1+phi*theta)/(phi+theta)^2*(1-phi^2)*(1-theta^2)
  s2=getglobal("t1")      ; sum of squared residuals
  s2=s2/n                 ; estimate of white noise variance
endp
;------------------------------------------------------------------
proc(y)=innova(par)       ; the innovation algorithm
  phi=par[1]
  theta=par[2]
  if (abs(phi-theta)<1e-5)
    y = 1e+10
  else
    zz=getglobal("zz")
    n=rows(zz)
    y=0
    t1=0
    t2=0
    xhat=zz[1]
    r=(1+2*theta*phi+theta^2)/(1-phi^2)
    i = 1
    while(i<n)
      thin = theta/r
      r = 1 + theta^2 -theta^2 / r
      xhat = phi*zz[i]+thin * (zz[i]-xhat)
      t1=t1+((zz[i+1]-xhat)^2)/r
      t2=t2+log(r)
      i=i+1
    endo
    y=log(t1/n)+t2/n
    putglobal("t1")
  endif
endp	
