proc()=bitree(vers,task)
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       bs1,mcmillan
; -----------------------------------------------------------------
;   Macro         bitree
; -----------------------------------------------------------------
;   Description   calculates option prices 
;                 using the Binomial tree
; -----------------------------------------------------------------
;   Usage         bitree(vers,task)
;   Input         
;     Parameter   vers  
;     Definition      scalar: (=0) - european option, (=1) - american option
;     Parameter   task  
;     Definition      scalar: (=1) - without dividend, (=2) - with
;                             continuously paid dividend, (=3) - in % 
;                             of the stock value", (=4) - with a fixed 
;                             dividend at the end of T, (=5) - if for 
;                             exchange rate
; -----------------------------------------------------------------
;   Example   library("finance")
;             bitree(1, 1)
; -----------------------------------------------------------------
;   Result    option price  
; -----------------------------------------------------------------
;   Notes	    See optstart
; -----------------------------------------------------------------
;   Author    Sperlich, Chtcherbinina  970311 
; -----------------------------------------------------------------
;   input of basic determinants
valuestrs1 = "Price of Underlying Asset"|"Exercise Price"|"Domestic Interest Rate per Year (%)"|"Volatility per Year (%)"|"Time to Expiration (Years)"|"number of intervals"
if (exist("v1")==0)
  v1=100|100|10.517|30.0|0.04|4
endif
values1=v1
v1=readvalue(valuestrs1,values1)
	s0=v1[1]			;stock price
	k =v1[2]			;exercise price	
	i =log(0.01*v1[3]+1)	        ;rate of interest
	sigma=0.01*v1[4]         	;volatility
	t =v1[5]			;time to expiration
        n =v1[6]                        ;number of intervals 
 q = 0		      ;definition of variables to avoid error if task 1 is chosen
 div = 0
 tdiv= 1
 perc= 0
 values2=0
 values3=1|0|0
 values4=1|0|0 
 values5=0 
tdiv = 0
do
 if(task)
	switch
	case(task==2)	valstr2 = "Dividend (Year,%)" 
			q=readvalue(valstr2, values2)
			q=log(0.01*q+1)
			break
	case(task==3)	valstr3 = "Number of pay outs"|"time of 1.pay out"
                        valstr3 = valstr3|"1.Dividend (in % of stock price)"
                        erg  =readvalue(valstr3, values3)
                        nodiv=erg[1]
                        tdiv = matrix(nodiv)
                        tdiv[1]= erg[2]                       
                        perc = matrix(nodiv)
                        perc[1]= erg[3]
                        j = 1
                        while (j<nodiv)   
                          valstr3 = "time of next Dividend"|"amount in % of stock price"
                          erg=readvalue(valstr3, values3[2:3])
                          tdiv[j+1]= erg[1]
                          perc[j+1]= erg[2]
                          j=j+1
                        endo
                        perc = perc/100
			break
	case(task==4)	valstr4 = "Number of pay outs"|"time of 1.pay out"
                        valstr4 = valstr4|"1.Dividend"
                        erg  =readvalue(valstr4, values4)
                        nodiv=erg[1]
                        tdiv = matrix(nodiv)
                        tdiv[1]= erg[2]
                        div = matrix(nodiv)
                        div[1]= erg[3]
                        j = 1
                        while (j<nodiv)   
                          valstr4 = "time of next Dividend"|"amount in % of stock price"
                          erg=readvalue(valstr4, values4[2:3])
                          tdiv[j+1]= erg[1]
                          div[j+1] = erg[2]
                          j=j+1
                        endo
			break
	case(task==5)   valstr5 = "Foreign Interest Rate (Year,%)" 
			q=readvalue(valstr5, values5)
			q=log(0.01*q+1)
			break
	endsw
 endif
if (max(tdiv) > t) 
   "error: last payoff has to occur before expiration date"
endif
 until (max(tdiv)<=t) 
 
;******************  Calculate the tree S of stock prices     
 tdivn = floor(tdiv/t*n-0.0001) +1  ; tdivn runs from 1 to (n+1)
 deltat=t/n                      ; Intervallaenge      
 s=matrix(n+1,n+1)*0     
  if (task==4)
    barwert = matrix((n+1))*0
    jtau = nodiv-1
    while (jtau>=0)      
     jt = tdivn[(jtau+1)]
     if (jtau>0)
       upbound=tdivn[jtau]
     else
       upbound=0
     endif
      while (jt>upbound)
        j = nodiv
        while (j>=(jtau+1))
          tt = (jt-1)*deltat
dim(barwert)
dim(div)
dim(tdiv)
jt
j
          barwert[jt] = barwert[jt]+div[j]/exp(i*(tdiv[j]-tt))
          j = j-1
        endo
        jt = jt-1
      endo
      jtau = jtau-1
    endo
    s[1,1]=s0-barwert[1]
  else
    s[1,1]=s0
  endif
  u=exp(sigma*sqrt(deltat))       ; Parameter u      
  d=1/u                           ; Parameter d      
  p=0.5+0.5*(i-sigma^2/2)*sqrt(deltat)/sigma      
  d1=matrix(n+1)                  ; Anlegen der Matrix D      
  u1=matrix(n+1)                  ; Anlegen der Matrix U      
  j=1                             ; Laufvariable      
  while(j .< n+1)      
    v1=matrix(n+1)      
    v1[1:j,]=(matrix(j)*d).^aseq(j, j, (-1))      
    d1=d1~v1                      ; Matrix D      
    v1[2:j+1,]=(matrix(j)*u).^aseq(1, j, 1)      
    u1=u1~v1                      ; Matrix U   
    j=j+1      
  endo      
  u1[1,]=matrix(1, n+1)      
  s=s[1,1].*u1.*d1                ; Berechnung der Aktienkurse      
 if (task==4)
   s = s .+ barwert'
 endif
 if (task==3)
   j = 1
   while (j<=nodiv)
     s[ ,(tdivn[j]+1):(n+1)]=s[ ,(tdivn[j]+1):(n+1)]*(1-perc[j]) 
     j = j+1
   endo
 endif
 " tree of possible stock prices "
 s
;*************  Calculate the inner values of Call/Put
  iw=matrix(n+1, n+1, 1)        
  selhead = "What Kind of Option do You have?"
sel = 0|0
do 
  j=1   
  zeroma = matrix(1,n+1)*0
  selitem = "Call"|"Put" 
  sel = selectitem (selhead, selitem)
  if (sel[1])
   while(j .< n+2)   
    iw[j,]=max((zeroma|(s[j,]-k))) ; Max (0, S-K) (Calloption)   
    j=j+1   
   endo   
  endif 
  if (sel[2])
   while(j .< n+2)    
    iw[j,]=max((zeroma|(k-s[j,]))) ; Max (0, K-S) (Putoption)   
    j=j+1   
   endo 
  endif
until (sum(sel)==1)
;*************  Calculate the option prices (first european)   
  ow=matrix(n+1, n+1)*0              
  ow[,n+1]=iw[,n+1]               ; einfuegen innerer Wert bei RLZ=0   
  jj=n                            ; Laufvariable fuer Zeit   
  while(jj .> 0)   
    j=jj                          ; Laufvariable Kursveraenderung   
    while(j .> 0)   
      ow[j,jj]=exp(-i*deltat)*(p*ow[j+1,jj+1]+(1-p)*ow[j,jj+1]) ; E(OW)      
  ;++++ now the difference between american and european options      
    if (vers==1)
      ow[j,jj]=max(#(iw[j,jj], ow[j,jj]))'    ; ov = Max (iv, europ. ov)
    endif
      j=j-1
    endo
  jj=jj-1
  endo
" tree of option prices "
ow
sentence=" The price of the option at time t_0 is "
 opv = string("%4.4f",ow[1,1])
 lin=("-------------------------------------")
 aus= " "|lin|sentence|opv|lin|" "  
 aus
endp
