proc(beps)=bootstrap(eps,nboot,kind)   
; -----------------------------------------------------------------
; Library  	  stats
; -----------------------------------------------------------------
;  See_also       uniform
; -----------------------------------------------------------------
;   Macro         bootstrap
; -----------------------------------------------------------------
;   Description   This macro gives bootstrap replications of different
;                 kind for models without known distribution of 'eps'
; -----------------------------------------------------------------
;   Usage         beps = bootstrap(eps,nboot,kind)    
;   Input
;     Parameter   eps  
;     Definition      n x 1 vector , the sample that has to be bootstraped
;     Parameter   nbbot 
;     Definition      scalar , the wished number of bootstrap replications
;     Parameter   kind 
;     Definition      string , saying what kind of bootstrap is wished:
;                     "wild" (using golden cut rule), "permut" (simple 
;                     permutation), "naive" (naive bootstrap)
;   Output                        
;     Parameter   beps 
;     Definition     n x nb matrix, bootstrap replications
; -----------------------------------------------------------------
;   Example   library("stats")
;             randomize(12345)
;             n     = 150
;             eps   = normal(n)
;             beps  = bootstrap(eps,99,"wild")
;             beps
; -----------------------------------------------------------------
;   Result    Contents of bootstrap replications for eps
; -----------------------------------------------------------------
;   Author    Sperlich   970728 
; -----------------------------------------------------------------
  n = rows(eps)
switch
  case(kind=="wild")
    aa = (1-sqrt(5))/2  
    bb = (1+sqrt(5))/2  
    cc = (5+sqrt(5))/10  
    mult = uniform(n,nboot) 
    mult = aa*(mult.<cc) + bb*(mult.>=cc) 
    beps = (mult .* eps) 
  break
  case(kind=="permut")
    beps = matrix(n,nboot)
    j = 1
    while (j<=nboot)
      perm = uniform(n)~eps
      beps[,j] = sort(perm,1)[,2]
      j = j+1
    endo
  break
  case(kind=="naive")
    beps = matrix(n,nboot)
    j = 1
    perm = floor(uniform(n,nboot)*0.99999*n)+1
    while (j<=nboot)
      beps[,j] = eps[perm[,j]]
      j = j+1
    endo     
  break
endsw
endp
