proc(y)=boxcox(x,p)            
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------
; See_also     twboxcox hinesplot boxcoxdens
; -----------------------------------------------------------------------
; Macro        boxcox
; -----------------------------------------------------------------------
; Description  computes the Box-Cox transformation of x
; -----------------------------------------------------------------------
; Usage        y = boxcox (x, p)
; Input
;   Parameter  x 
;   Definition n x q 
;   Parameter  p
;   Definition scalar
; Output
;   Parameter  y
;   Definition n x q    transformed data
; -----------------------------------------------------------------------
; Example      ; loads the library stats
;              library("stats")   
;              ; loads the library graphic
;              library("graphic")   
;              ; reset random generator 
;              randomize(0)
;              ; generate x (skewed)
;              x = 0.05+0.9.*uniform (250)
;              x = qfc (x, 2)
;              ; create a display
;              t = createdisplay(1,2)
;              ; show a qq-plot of x
;              xp = grqqn(x)
;              show (t, 1, 1, xp)
;              ; now transform with boxcox (p=0)
;              y = boxcox(x, 0)
;              ; show a qq-plot of y
;              yp = grqqn(y)
;              show (t, 1, 2, yp) 
; -----------------------------------------------------------------------
; Result       shows first a qq plot with the original data. The data are
;              skewed. The second plot shows a qq-plot with the
;              transformed data. The data are less skewed now and the
;              distribution looks more normal. 
; -----------------------------------------------------------------------
; Author       Michaela Dranganska, Ulrich Dorazelski, 951002,
;              Susanne Hannappel, 970220 
;              Sigbert Klinke, 970820
; ----------------------------------------------------------------------
   if(abs(p).<1.0e-6)
     y=log(x)      
   else      
     y=(x^p-1)./p      
   endif      
endp  
