  proc(codi,codj,codsi,codcj) = caanalyse(x,xl,xc,tl,out,outd)
; -----------------------------------------------------------------
;    Library    stats
; -----------------------------------------------------------------
;    See_also  corresp
; -----------------------------------------------------------------
;    Macro  caanalyse
; -----------------------------------------------------------------
;    Description    supplementary macro for corresp which performs
;           correspondence analysis for a contingency table
; -----------------------------------------------------------------
;   Link ../tutorials/correstart.html  Correspondence Analysis
;-----------------------------------------------------------------
;   Author   Vila  CO ,  970904, Michal Benko, 000417, zh 000705
; --------------------------------------------------------

         at=sum(x,2)                 /* Row sums                */
         ia=matrix(rows(at),1)
         Dn= diag(at)                /* Dn                      */
         Dn1=diag(ia./at)            /* D(-1,n)                 */
         Ac=x'*Dn1*x                 /* F'D(-1,n)F              */
         bt=sum(x)'                  /* Column sums             */
         ib=matrix(rows(bt),1)
         Dp= diag(bt)                /* Dp                      */
         Dp1=diag(ib./bt)            /* D(-1,p)                 */
         ibt=ib./bt
         Dpn12=diag(sqrt(ibt))       /* D(-1/2,p)               */
         Dp12=diag(sqrt(bt))         /* D(1/2,p)                */
         A=Dpn12*Ac*Dpn12            /* A=D(-1/2,p)*F'D(-1,n)F*D(-1/2,p) */
         {e,v}=eigsm(A)
         tmp=sort(e~v',-1)
         tmpp=tmp'
         t=tmpp[,2:cols(tmpp)]
         tmp=t'                      /* Cancel of trivial eigenvalue and eigenvector */
         e=tmp[,1]                   /* Eigenvalue  : (p-1)x1        */
         v=tmp[,2:cols(tmp)]'        /* Eigenvector : px(p-1)        */
         pal=at./sum(at)             /* Row relative weights         */
         pac=bt./sum(bt)             /* Column relative weights      */
         {sx}=castr(x)
    if (out==1)
    	output(outd, "reset")
    endif
    tl
    "Primitive data"
    x
    "EIGENVALUES AND PERCENTAGES"
    eig=e~((e~cumsum(e))./sum(e))*100
    {seig}=castr(eig)
    seig
                                               /* Eigenvalues & Percentages       */
        codi=Dn1*x*Dpn12*v                     /* Row coordinates                 */
                                               /* codi,   nx(p-1)                 */
        en1=diag(matrix(rows(e),1)./e)
        contai=((en1*(codi^2)'*Dn)'*100)'
                                               /* Absolute contributions (rows)   */
                                               /* contai, nx(p-1)                 */
        t2=(codi^2)
        t1=sum(t2,2)
        ts=diag(matrix(rows(t1),1)./t1)
        contri=(t2'*ts)'                       /* contri, nx(p-1)                 */
    "ACTIVE ITEMS"
        dal=sqrt(t1)                           /* Distances (row) to the origin   */
        pdal=pal~dal
        {spdai}=castr(pdal)
    "Row relative weights and distances to the origin"
     spdai
    "Coordinates of the rows"
        {scoordi}=castr(codi)
     scoordi
    "Contributions of the rows"
        {scontri}=castr(contai)
     scontri
    "Squared correlations of the rows"
        {scorri}=castr(contri)
     scorri
        o=diag(matrix(rows(e),1)./sqrt(e))
        codj=(o*(Dp1*x'*codi)')'                 /* Column coordinates ,codj,px(p-1) */
        contaj=(en1*(codj^2)'*Dp)'.*100          /* Absolute contributions (column)  */
                                                 /* px(p-1),contaj                   */
        t2=(codj^2)
        t1=sum(t2,2)
        ts=diag(matrix(rows(t1),1)./t1)
        contrj=(t2'*ts)'                         /* Squared correlations (column)    */
                                                 /* contrj, px(p-1)                  */
    "Column relative weights and distances to the origin"
        dac=sqrt(t1)                             /* Distances (column) to the origin */
        pdac=pac~dac
        {spdaj}=castr(pdac)
    spdaj
    "Coordinates of the columns"
        {scoordj}=castr(codj)
    scoordj
    "Contributions of the columns"
        {scontrj}=castr(contaj)
    scontrj
    "Squared correlations of the columns"
         {scorrj}=castr(contrj)
    scorrj

       codsi=0                                   /*  SUPPLEMENTARY ROWS         */
       if((rows(xl)>=2)||(cols(xl)>=2))

          Dln1=diag(matrix(rows(xl),1)./sum(xl,2))
          codsi=(o*(Dln1*xl*codj)')'             /* Row coordinates             */
                                                 /* codsi,    kx(p-1)           */
          t2=(codsi^2)
          t1=sum(t2,2)
          ts=diag(matrix(rows(t1),1)./t1)
          contrsi=(t2'*ts)'                      /* Squared correlations (row)  */
                                                 /* px(p-1)                     */
          sat=sum(xl,2)
          psl=sat./sum(sat)
          dsl=sqrt(t1)
          {spdsl}=castr(psl~dsl)
    "SUPPLEMENTARY ITEMS"
    "Row relative weights and distances to the origin"
    spdsl
    "Coordinates of the rows"
          {scodsi}=castr(codsi)
    scodsi
    "Squared correlations of the rows"
          {scontrsi}=castr(contrsi)                /* contrsi, kx(p-1)              */
    scontrsi
        endif

       codcj=0                                   /* SUPPLEMENTARY  COLUMN         */
       if((rows(xc)>=2)||(cols(xc)>=2))
          Dcp1=diag(matrix(cols(xc),1)./sum(xc)')
          codcj=(o*(Dcp1*xc'*codi)')'            /* Column coordinates            */
                                                 /* codcj, qx(p-1)                */
          t2=(codcj^2)
          t1=sum(t2,2)
          ts=diag(matrix(rows(t1),1)./t1)
          contrcj=(t2'*ts)'                      /* Squared correlations (column) */
          sbt=sum(xc)'
          psc=sbt./sum(sbt)
          dsc=sqrt(t1)
          {spdsc}=castr(psc~dsc)
    "Column relative weights and distances to the origin"
    spdsc
    "Coordinates of the columns"
        {scodcj}=castr(codcj)
    scodcj
    "Squared correlations of the columns"
        {scontrcj}=castr(contrcj)
    scontrcj
       endif
    if (out==1)
       output (outd, "close")
    endif
  endp

