proc(y)=cartregr(tree, x, stri)
; ---------------------------------------------------------------------
; Library     xclust
; ---------------------------------------------------------------------
; See_also    cartsplit
; ---------------------------------------------------------------------
; Macro       cartregr
; ---------------------------------------------------------------------
; Description applies the the tree to a user given data set.
; ---------------------------------------------------------------------
; Usage       y = cartregr (tree, x {, stri})
; Input       
; Parameter   tree
; Definition  list,	result of cartsplit
; Parameter   x
; Definition  nxp, 	X-variables 
; Parameter   stri
; Definition  text,	which values should be returned
; Output      
; Parameter   y
; Definition  nx1, 	result
; ---------------------------------------------------------------------
; Notes       stri can take the values "nodes" for the node number
;             where each observation will come, "ssr" for the SSR in the node
;             "nelem" for the number of observations in the node or "mean"
;             (default) for the mean value in the node
; ---------------------------------------------------------------------
; Example     ; load library xclust and plot
;             library("xclust")             
;             library("plot")
;             ; set random seed               
;             randomize(1)
;             ; read swiss banknote data
;             dendat=read("bank2")
;             ; select the last three variables
;             dendat=dendat[,4:6]
;             ; choose 9 bins in each dimension
;             binlkm=9
;             ; compute density estimate
;             regdat=dentoreg(dendat,binlkm)
;             ; compute CART and tree
;             type=#(1,1,1)
;             opt=cartsplitopt("minsize",80,"mindev",0,"mincut",1)
;             tr=cartsplit(regdat.ind,regdat.dep,type,opt)
;             ; compute cuts and show with colored datapoints
;             g=cartregr(tr, dendat, "node")
;             {gcat,gind}=groupcol(g, rows(g))
;             setmaskp(dendat, gind)
;             plotcart2(dendat, tr)
; ---------------------------------------------------------------------
; Result      shows the cuts and the datapoints of the original data
;             colored after the node they fall in. Choose X2 and X3 as
;             projection plane.
; ---------------------------------------------------------------------
; Keywords    CART
; ---------------------------------------------------------------------
; Reference   Breiman, L., Friedman, J., Olshen, R., and Stone, C. J. (1984). 
;             Classification and Regression Trees. Chapman & Hall, New York
; ---------------------------------------------------------------------
; Link        ..\tutorials\cartstart.html CART Tutorial
; ---------------------------------------------------------------------
; Author      2000-04-16, Sigbert Klinke
; ---------------------------------------------------------------------
  if (exist("stri")<>2)
    stri = "mean"
  endif
  y=matrix(rows(x))
  i=0
  val=0
  len=0
  str=0
  while (i<rows(tree.vec))
    i = i+1
    if (!isNaN(tree.vec[i]))
      cnd = (y.=i)
      if (sum(cnd))
        ind  = paf(1:rows(y), cnd)
        cmd  = string ("len=rows(tree.val.split%.0f)", i-1)
        exec(cmd)
        switch 
        case (len==1) // continuous
          cmd  = string ("val=atof(tree.val.split%.0f)", i-1)
          exec(cmd)
          cnd  = (x[ind, tree.vec[i]]>val)
        case (len==2) // discrete
          cmd  = string ("str=tree.val.split%.0f[2]", i-1)
          exec(cmd)
          val  = atof(strtok(str, ","))
          cnd  = sum((x[ind, tree.vec[i]]==val'),2)
        endsw
        if (sum(cnd.=0))
          indl = paf (ind, cnd.=0)
          y[indl] = i+1
        endif
        if (sum(cnd.=1))
          indr = paf (ind, cnd.=1)
          y[indr] = tree.endpoint[i+1]+1
        endif
      endif
    endif
  endo
  switch
  case (stri=="nelem")
    y = tree.nelem[y]
    break
  case (stri=="ssr")
    y = tree.ssr[y]
    break
  case (stri=="node")
    break
  default
    y = tree.mean[y]
    break
  endsw  
endp
