proc(opt)=cartsplitopt(s1, s2, s3, s4, s5, s6)
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     cartsplit, cartcv, leafnum, maketr,  pred,
;              prederr, prune, prunecv, pruneseq, prunetot, ssr, kuva
; -----------------------------------------------------------------------
; Macro        cartsplitopt
; -----------------------------------------------------------------------
; Description  sets optional parameters for cartsplit (spliting of
;              for classification and regression trees)
; -----------------------------------------------------------------------
; Usage        opt = cartsplitopt (s1 {, s2{, s3, ...}})
; Input        
;   Parameter  s1, s3 s5
;   Definition string
;   Parameter  s2, s4, s6
;   Definition numerical values
; Output       
;   Parameter  opt
;   Definition list of optional parameters
; -----------------------------------------------------------------------
; Notes        The order of the optional parameters does not play
;              any role. You have just to keep the internal order
;              string value string value...
;
;              The following string values can be used:
;
;              minsize    the number of observations in child nodes 
;                         must exceed or to be equal to minsize for 
;                         a split to be allowed
;              mincut     nodes of size mincut or larger are candidates
;                         for a split; the growing continues if there are 
;                         at least mincut observations in a node
;              mindev     if the deviance of the node (sum of mean squared
;                         errors, value of cs.var) is less or equal to
;                         mindev, the node will not be splitted anymore
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
;              ; generate some data, y depends deterministically from x1:
;              ; if 0 <= x1 < 0.5 then y=0, if 0.5 <= x1 <= 1, then y=1
;              x1=#(0.1, 0.2, 0.3, 0.4, 0.45, 0.6, 0.7, 0.8, 0.9, 0.95)
;              x2=uniform(10,1)
;              x=x1~x2
;              y=#(0,0,0,0,0,1,1,1,1,1)
;              opt = cartsplitopt ("minsize", 1, "mindev", 0, "mincut", 1)
;              cs = cartsplit (x, y, #(1,1), opt)
;              ; show the results
;              cs
; -----------------------------------------------------------------------
; Result       produces an optional parameters which contains the default
;              values used in cartsplit without optional parameter
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 980211         
; -----------------------------------------------------------------------
  t = exist("s1")|exist("s2")|exist("s3")| exist("s4")|exist("s5")|exist("s6")
  error (t[1]==0, "cartsplitopt: no parameter given")
  l = list(s1)
  i = 1
  while (i<rows(t))
    i = i+1
    if (t[i])
      cmd = string ("append(l, s%.0f)", i)
      exec (cmd)
    endif
  endo
  i = 0
  minsize = 1
  mincut  = 1
  mindev  = 0
  opt = list (minsize, mincut, mindev)
  while (i<rows(t))
    i = i+1
    if ((t[i]==2) && (t[i+1]==1))
      cmd = string ("opt.%s = ", l{i})
      cmd = cmd + string ("s%.0f", i+1)
      exec (cmd)
    endif 
  endo
endp

