proc(uselret, h)=chbase(usel, oldh)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     chview chfunc
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        chbase
; -----------------------------------------------------------------------
; Description  Changes interactively the wavelet coeffients. You may
;              choose between Haar, Daubechies2 and Coiflet2.
; -----------------------------------------------------------------------
; Usage        {ur, h} = chbase (u, oldh)
; Input
;   Parameter  u 
;   Definition vector   commands
;   Parameter  oldh 
;   Definition n x 1 array    old coefficients 
; Output
;   Parameter  ur
;   Definition vector   commands
;   Parameter  h
;   Definition m x p array    new coefficients
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  h = oldh
  selhead = "Choose basis"
  selitem  = "Haar"|"Daubechies4"|"Coiflet2"
  ru = rows(usel)
  if (ru.>1)
    sel  = (usel[2].=(1:3))
    if (ru.>2)
      usel = usel[1]|usel[3:ru]
    else
      usel = usel[1]
    endif
  else
    sel = selectitem (selhead, selitem)
  endif
  if (sel[1])
    h = getglobal ("haar")
  endif
  if (sel[2])
    h = getglobal ("daubechies4")
  endif
  if (sel[3])
    h =  getglobal ("coiflet2")
  endif
  uselret = usel
endp
