proc(uselret, x)=chfunc(usel, oldx, n, sel)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     chview chbase
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        chfunc
; -----------------------------------------------------------------------
; Description  Generates specific functions (Jump, Up-down, Sine, Freq.
;              sine and Doppler). If all entries of sel are zero then you
;              can choose interactively the function otherwise the
;              selected function will be generated. 
; -----------------------------------------------------------------------
; Usage        {ur, x} = chfunc(usel, oldx, n, sel)
; Input
;   Parameter  usel 
;   Definition vector   commands
;   Parameter  oldx
;   Definition m x 1 array    old data
;   Parameter  n
;   Definition scalar         number of new datapoints
;   Parameter  sel
;   Definition k x 1 array    
; Output
;   Parameter  ur
;   Definition vector   commands
;   Parameter  x
;   Definition m x 1 array    new data
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  x = oldx
  if (sum(sel).=0)
    selhead = "Choose function"
    selitem  = "Jump"|"Up-down"|"Sine"|"Freq. sine"|"Doppler"
    ru = rows(usel)
    if (ru.>1)
      sel  = (usel[2].=(1:5))
      if (ru.>2)
        usel = usel[1]|usel[3:ru]
      else
        usel = usel[1]
      endif
    else
      sel = selectitem (selhead, selitem)
    endif
  endif
  if (rows(sel).<5)
    sel = sel|(0.*matrix(5-rows(sel)))
  endif
  if (sel[1])
    x = sort(uniform(n).>(0.25+0.5*uniform(1)))
  endif
  if (sel[2])
    t  = ((1:n)-0.5)./n
    j = 0.25+0.5*uniform(1)
    x =  t.*(t.<j) + 0.5.*(1-t).*(t.>=j)
  endif
  if (sel[3])
    t = ((1:n)-0.5)./n
    x = sin(4*pi*sel[3]*t)
  endif
  if (sel[4])
    t  = 2*((1:n/2)-0.5)./n
    x1 = sin(4*pi*sel[4]*t)
    x2 = sin(16*pi*sel[4]*t)
    x  = x1|x2
  endif
  if (sel[5])
    t  = ((1:n)-0.5)./n
    x = sqrt(t).*sin((4*(1-t))^3)
  endif
  uselret = usel
endp
