proc(b)=chol(a)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      chold
; -----------------------------------------------------------------
;   Macro         chol
; -----------------------------------------------------------------
;   Description   computes the Cholesky decomposition of a symmetric,
;                 positive definite matrix
; -----------------------------------------------------------------
;   Usage         y = chol(x)
;   Input
;     Parameter   x
;     Definition      n x n matrix 
;   Output
;     Parameter   y
;     Definition      n x n matrix, containing the Cholesky 
;                                   decomposition of x
; -----------------------------------------------------------------
;   Example   library("multi")
;             y=chol(eye(2)*2)
;             y
; -----------------------------------------------------------------
;   Result         Contents of y
;                  [1,] 1.4142        0 
;                  [2,]      0   1.4142
; -----------------------------------------------------------------
;   Author    Christian Hafner, Sperlich  971027
; -----------------------------------------------------------------
  n=rows(a)
  j=1
  while(j<=n)
    k=1
    while(k<=(j-1))
      i=j
      while(i<=n)
        a[i,j]=a[i,j]-a[i,k]*a[j,k]
        i=i+1
      endo
      k=k+1
    endo
    a[j,j]=sqrt(a[j,j])
    k=j+1
    while(k<=n)
      a[k,j] = a[k,j]/a[j,j]
      a[j,k] = 0
      k=k+1
    endo
    j=j+1
  endo
b=a'
endp  
