proc(selgroup)=choosegroup(data,selvar,dcoltype)  
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     choosevariable choosevarable2 choosevariablep 
;              choosevariableY doista 
; -----------------------------------------------------------------------
; Macro        choosegroup
; -----------------------------------------------------------------------
; Description  selction of group variables (discrete type) 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
 if(sum(data.colvar&&data.coltype&&(1-selvar)&&data.colmissing))
    ;variables have to be discrete, not deleted and not already selected
    ;otherwise no group variable selectable
    selhead1="Select group variable(s)"
    selitem1=paf(data.colname, (data.colvar && data.coltype && (1-selvar) && data.colmissing))
    selitem1="all"|selitem1
    selind1=paf(1:rows(data.colname),(data.colvar && data.coltype && (1-selvar) && data.colmissing))
    selgroup=0*matrix(rows(data.colname))
    sel=selectitemlist(selhead1,selitem1,15)
    r=rows(sel)
    if (sel[1]==1) 
      selgroup[selind1]=1*matrix(r-1)
    else
      selgroup[selind1] = sel[2:r]
    endif
  else
   selgroup=0*matrix(1:cols(data.colname))
endif
endp