proc(uselret, v)=chview(usel, oldv)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     chfunc chbase
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        chview
; -----------------------------------------------------------------------
; Description  Enforces a specific view of the wavelet mother 
;              coefficients (Standard, Ordered, Circle and Partial sum).
;              If none is selected then the old view will be returned.
; -----------------------------------------------------------------------
; Usage        {ur, v} = chview (usel, oldv)
; Input
;   Parameter  usel 
;   Definition vector   commands
;   Parameter  oldv
;   Definition scalar   old view
; Output
;   Parameter  ur
;   Definition vector   commands
;   Parameter  v
;   Definition scalar   new view
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  v = oldv
  selhead = "Change view"
  selitem = "Standard view"|"Ordered coefficients"|"Circle coefficients"|"Partial sum"
  ru = rows(usel)
  if (ru.>1)
    sel  = (usel[2].=(1:5))
    if (ru.>2)
      usel = usel[1]|usel[3:ru]
    else
      usel = usel[1]
    endif
  else
    sel = selectitem (selhead, selitem)
  endif
  if (sel[1])
    v = 1
  endif
  if (sel[2])
    v = 2
  endif
  if (sel[3])
    v = 3
  endif
  if (sel[4])
    v = 4
  endif
  uselret = usel
endp
