proc(z,ylim)=cir()
; ----------------------------------------------------------------------
; Library 	  finance
; ----------------------------------------------------------------------
;  See_also	  stocksim, european, american
; ----------------------------------------------------------------------
;   Macro	  cir
; ----------------------------------------------------------------------
;   Description   displays the yield curve for given parameters under 
;                 the model of Cox/Ingersoll/Ross (1985)
; ----------------------------------------------------------------------
;   Usage         {z,ylim} = cir()
;   Output
;     Parameter   z
;     Definition  matrix, first column: time to maturity, second column: 
;                 bond prices, third column: bond yields
;     Parameter   ylim 
;     Definition  limit of yield for increasing maturity 
; ---------------------------------------------------------------------
; Reference       Cox, J., J. Ingersoll, S. Ross (1985) "A Theory of the 
;                 Term Structure of Interest Rates", 
;                 Econometrica 53: 385-408.
; ----------------------------------------------------------------------
;   Author        Christian Hafner, 980414
; ----------------------------------------------------------------------
head = " k: Reversion rate" | " mu: steady state" | " s: volatility" 
head = head | " n: time horizon" | " short rate"
noquit = 1
while (noquit)
r    = readvalue(head, 0.1|0.1|0.1|50|0.1)
k    = r[1]             ; reversion rate
mu   = r[2]             ; steady state of the short rate
s    = r[3]             ; volatility coefficient
n    = r[4]             ; time horizon in years
sr   = r[5]             ; today's short rate
tau  = 1:n              ; vector of maturities in years
error(s==0, "Specify Volatility other than zero!")
error(k<0, "Mean reversion rate should be non-negative!")
; 
; ------ calculation -------------------------------------
;
gam  = sqrt(k^2+2*s^2)
ylim = 2*k*mu/(gam+k)
g    = 2*gam + (k+gam)*(exp(gam*tau)-1)
b    = -(2*(exp(gam*tau)-1))./g;
a    = 2*k*mu/s^2*log(2*gam*exp((k+gam)*tau/2)./g)
p    = exp(a+b*sr)      ; the bond prices
y    = -1/tau.*log(p)   ; the yields
w    = tau~y
wlim = tau~matrix(n,1)*ylim
;
; ------ now the graphic output --------------------------
;
setmaskl(w,tau',1,1,5)
setmaskl(wlim,tau',4,3,3)
setmaskp(w,0,1,1)
setmaskp(wlim,0,1,1)
d    = createdisplay(1,1)
show(d,1,1,w,wlim)
setgopt(d,1,1, "yvalue",0|1,"title","Yield Curve, Cox/Ingersoll/Ross Model")
setgopt(d,1,1,"xlabel", "Time to Maturity", "ylabel", "Yield")
sel=selectitem("Another one?","Yes"|"No", "single")
if (sel[2]==1)
   noquit=0
endif
endo
z=tau~p~y
endp
