proc (x) = cmatdiv (a, b) 
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cinv cmatmul
; -----------------------------------------------------------------------
; Macro        cmatdiv
; -----------------------------------------------------------------------
; Description  Computes the complex solution of A x = b
; -----------------------------------------------------------------------
; Usage        x = cmatdiv (a, b)
; Input
;   Parameter  a
;   Definition complex matrix A
;   Parameter  b
;   Definition complex matrix b
; Output
;   Parameter  x
;   Definition complex matrix
; -----------------------------------------------------------------------
; Example      library("math")
;              m = #(1,0)~#(0,1)
;              a = complex (m,m)
;              b = complex (#(1,1))
;              cmatdiv (a, b)
; -----------------------------------------------------------------------
; Result       Contents of x.re

;              [1,]      0.5 
;              [2,]      0.5 
;              Contents of x.im

;              [1,]     -0.5 
;              [2,]     -0.5 
; -----------------------------------------------------------------------
; Keywords     complex numbers, complex linear equation
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  error (comp(a, "re")<1, "cmatdiv : No real part in a found")
  error (comp(a, "im")<1, "cmatdiv : No imaginary part in a found")
  error (comp(b, "re")<1, "cmatdiv : No real part in b found")
  error (comp(b, "im")<1, "cmatdiv : No imaginary part in b found")  
  x = cinv (a)
  x = cmatmul (x, b)
endp

