proc(output)=confidenceb(b,bse,x,Vin,colname)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista durbinwatson collinearity confidencey covmatrix 
;              descriptivelinreg regressionstatistic
; -----------------------------------------------------------------------
; Macro        confidenceb
; -----------------------------------------------------------------------
; Description  computes the 95% confidence intervals for each beta after
;              regression analysis
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  if(Vin<>0)
    variablestr=" Constant   "|string (" %s", colname[Vin])
  else
   variablestr=" Constant  "
  endif
  alpha=.05
  d=rows(x)-rows(b)-1
  t=qft(1-alpha/2,d)
  bl=b-t.*bse
  bu=b+t.*bse
  firstline="95% confidence intervals for each b"
  secondline="-------------------------------------------------------"
  thirdline="lower bound                  upper bound"
  fourthline="-------------------------------------------------------"
  blstr=string("%11.4f   ",bl)
  bstr=string("b %2.0f %7.4f   ", 0:(rows(b)-1), b)
  bustr=string("%11.4f  ",bu)
  output=firstline|secondline|thirdline|fourthline|(blstr+bstr+bustr+variablestr)
endp 

