proc(d)=cor2dist(s, t)
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     vec2mat distance lpdist agglom corrdist
; -----------------------------------------------------------------------
; Macro        cor2dist
; -----------------------------------------------------------------------
; Description  transforms the values of the upper triangle of a
;              correlation matrix into distances, and it stores
;              these distances into a vector regarding the
;              sequence described in agglom
; -----------------------------------------------------------------------
; Usage        d = cor2dist(s, t)   
; Input
;   Parameter  s
;   Definition l x l  matrix of correlations (or association values
;                     with elements -1 <= s[i,j] <= 1)
;   Parameter  t
;   Definition kind of transformation: t=0: d=2-2s; t=1: d=abs(s)
; Output
;   Parameter  d
;   Definition d  l(l-1)/2 x 1 matrix containing the transformed values
;                              of the upper triangle of s. Afterwards
;                              the vector d can be used as the input
;                              parameter of the function AGGLOM. 
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; generate s data
;             s = #(1, .8, .5, 0)~#(.8, 1, 0.9, (-1))~#(, .5, .9, 1, .1)~#(0, (-1), .1, 1)
;             cor2dist(s,0)  
; -----------------------------------------------------------------------
; Result      Content of object d
;
;             [1,]      0.4 
;             [2,]        1 
;             [3,]        2 
;             [4,]      0.2 
;             [5,]        4 
;             [6,]      1.8 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 941111 
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  j=rows(s)
  d=matrix((j*j-j)/2)
  i=1
  do
    k=0
    i=i+1
    do
      k=k+1
      m=j*(k-1)-k*(k-1)/2+i-k
      d[m,1]=2-2*s[k,i]
      if(t.=1)
        d[m,1]=abs(s[k,i])
      endif 
    until(k.=i-1) 
  until(i.=j) 
endp 
