proc()=corresp(fadata,fsldata,fscdata,titl,fal,fac,fsl,fsc,outdoc)
; -----------------------------------------------------------------
;    Library    stats
; -----------------------------------------------------------------
;    See_also
; -----------------------------------------------------------------
;    Macro  corresp
; -----------------------------------------------------------------
;    Description    corresp executes Correspondence Analysis which
;           analyses and describes a contingency table
;           cross-tabulations) in terms of a reduced number of dimensions.
;                   Correspondence Analysis can be viewed as finding the
;                   best simultaneous representation of two sets that
;                   comprise the rows and columns of a data matrix, in order
;                   to obtain a summary description for large
;                   tables (cross-tabulations). This technique can be
;                   helpful in finding important underlying characteristics
;                   which might not be directly observed in the data.
;                   Graphical visualizations provide an insight and understanding
;                   tool for interpreting the data.
; -----------------------------------------------------------------
;   Link ../tutorials/correstart.html  Correspondence Analysis
;-----------------------------------------------------------------
;   Usage    corresp(fadata,fsldata,fscdata,titl,fal,fac,fsl,fsc,outdoc)
;    Input
;      Parameter  fadata
;      Definition   name of active data (I x J matrix) file, Obligatory Parameter
;      Parameter  fsldata
;      Definition   name of supplementary row data (K x J matrix) file
;      Parameter  fscdata
;      Definition   name of supplementary column data (I x Q matrix) file
;      Parameter  titl
;      Definition  title of data set (text string)
;      Parameter  fal
;      Definition  name of row label (I x 1 string vector) file
;      Parameter  fac
;      Definition  name of column label (J x 1 string vector) file
;      Parameter  fsl
;      Definition  name of supplementary row label (K x 1 string vector) file
;      Parameter  fsc
;      Definition  name of supplementary column label (Q x 1 string vector) file
;      Parameter  outdoc
;      Definition  name of output file, default = "out.txt" that consists of Eigenvalues
;                  corresponding to the principal axes, Coordinates of items on the principal axes,
;                  Contributions of active items relative to a principal axis,
;                  Squared correlations which indicate the part of the variance of
;                  a variable explained by a principal axis, Relative weights
;                  (marginal frequencies) and Distances of items to the origin.
;    Output
;      Parameter
;      Definition  - see above file "outdoc"
;                  - some graphs are obtainable by interactive requests.
;                    The graphs represent the configurations of items
;                    in projection planes formed by the first principal
;                    axes taken two at a time. They
;                    help to interpret the relations between items.
;                    Active row labels are written in blue,
;            Active column labels are written in green,
;                    Supplementary row labels are in red
;            Supplementary column labels are in magenta.
;
; -----------------------------------------------------------------
;  Example library("stats")
;      corresp("yeux.dat")
; -----------------------------------------------------------------
;  Result   You have the informations relative to the eigenvalues, coordinates of items
;           on the principal axes, ... etc in the file "yeux.txt".
;       You can also visualize the different items of "eye" and those of "hair" on graphs
;           with any two axes selected.
; -----------------------------------------------------------------
;  Example library("stats")
;      corresp("mjob.dat")
; -----------------------------------------------------------------
;  Result   You have all informations relative to the eigenvalues,
;           coordinates of items on the principal axes, ... etc in
;       the file "out.txt". You can visualize the active row
;           items labeled with the sequential numbers of rows
;           (color blue)  and active column items labeled with the
;           sequential numbers of columns (color green) on graphs.
;-----------------------------------------------------------------------
;   Reference
;      Lebart, L.; Morineau, A. and Piron, M. (1995): Statistique Exploratoire
;      Multidimensionnelle. Dunod, Paris;  page 67-103.
; -----------------------------------------------------------------
;   Author   Vila  CO ,  970904
; --------------------------------------------------------
setenv("outputstringformat","%s") /* added by michal */
    if( (exist("fadata")!=2) || (fadata=="null") )
         error(1, "Error : no valid data-file name")
    endif
    if(exist("fal")!=2)
         fal="null"
    endif
    if(exist("fac")!=2)
         fac="null"
    endif
    if(exist("fsldata")!=2)
         fsldata="null"
    endif
    if(exist("fsl")!=2)
         fsl ="null"
    endif
    if(exist("fscdata")!=2)
         fscdata="null"
    endif
     if(exist("fsc")!=2)
         fsc ="null"
    endif
    if(exist("titl")!=2)
         titl="DATA"
    endif
    out=1
    if(exist("outdoc")!=2)
         out=0
         outdoc="out.txt"
    endif
   {x,xrows,xcols,xl,xrowsl,xc,xcolsc} = cagetdata(fadata,fal,fac,fsldata,fsl,fscdata,fsc)

   {xf,xrowsf,xcolsf} = cacheckvar(x,xrows,xcols)

   {ai,aj,si,sj} = caanalyse(xf,xl,xc,titl,out,outdoc)

   cadisplay(ai,xrowsf,aj,xcolsf,si,xrowsl,sj,xcolsc,titl)
 endp

