proc (n) = countNotNumber (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      countNaN isInf isNaN isNumber
; -----------------------------------------------------------------
;  Keywords      missing values, infinite values
; -----------------------------------------------------------------
;   Macro        countNotNumber
; -----------------------------------------------------------------
;   Description  Counts how many elements of an array are missing
;                values, infinity or -infinity (NaN,Inf or -Inf).
; -----------------------------------------------------------------
;   Usage        y = countNotNumber (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  n
;     Definition amount of non numbers (between 0 and prod(dim(x)))
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = #(0/0, 1/0, -1/0, 1)
;             countNotNumber (x)
; -----------------------------------------------------------------
;   Result    
;             Contents of n
;	      [1,]     3 
; -----------------------------------------------------------------
;   Author    TTK, 960424
; -----------------------------------------------------------------

  n = sum (!#(abs(x) < Inf))
endp



